/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.filter.runtime;

import io.quarkus.oidc.client.runtime.AbstractTokensProducer;
import io.quarkus.oidc.client.runtime.DisabledOidcClientException;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;
import org.jboss.logging.Logger;

public class AbstractOidcClientRequestFilter
extends AbstractTokensProducer
implements ClientRequestFilter {
    private static final Logger LOG = Logger.getLogger(AbstractOidcClientRequestFilter.class);
    private static final String BEARER_SCHEME_WITH_SPACE = "Bearer ";

    public void filter(ClientRequestContext requestContext) throws IOException {
        try {
            String accessToken = this.getAccessToken();
            requestContext.getHeaders().add((Object)"Authorization", (Object)(BEARER_SCHEME_WITH_SPACE + accessToken));
        }
        catch (DisabledOidcClientException ex) {
            LOG.debug((Object)"Client is disabled, acquiring and propagating the token is not necessary");
            return;
        }
        catch (Exception ex) {
            LOG.debugf("Access token is not available, cause: %s, aborting the request", (Object)ex.getMessage());
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
        }
    }

    private String getAccessToken() {
        return this.awaitTokens().getAccessToken();
    }
}

