/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.Tokens;
import io.smallrye.mutiny.Uni;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import org.jboss.logging.Logger;

public class TokensHelper {
    private static final Logger LOG = Logger.getLogger(TokensHelper.class);
    private volatile TokenRequestState tokenRequestState;
    private static final AtomicReferenceFieldUpdater<TokensHelper, TokenRequestState> tokenRequestStateUpdater = AtomicReferenceFieldUpdater.newUpdater(TokensHelper.class, TokenRequestState.class, "tokenRequestState");

    public void initTokens(OidcClient oidcClient) {
        this.initTokens(oidcClient, Map.of());
    }

    public void initTokens(OidcClient oidcClient, Map<String, String> additionalParameters) {
        tokenRequestStateUpdater.set(this, new TokenRequestState((Tokens)oidcClient.getTokens(additionalParameters).await().indefinitely()));
    }

    public Uni<Tokens> getTokens(OidcClient oidcClient) {
        return this.getTokens(oidcClient, Map.of(), false);
    }

    public Uni<Tokens> getTokens(OidcClient oidcClient, Map<String, String> additionalParameters, boolean forceNewTokens) {
        Tokens tokens;
        block5: {
            TokenRequestState currentState = null;
            TokenRequestState newState = null;
            while (true) {
                boolean refreshTokenValid;
                if ((currentState = tokenRequestStateUpdater.get(this)) == null) {
                    newState = new TokenRequestState(this.prepareUni(oidcClient.getTokens(additionalParameters)));
                    if (!tokenRequestStateUpdater.compareAndSet(this, currentState, newState)) continue;
                    return newState.tokenUni;
                }
                if (currentState.tokenUni != null) {
                    return currentState.tokenUni;
                }
                if (forceNewTokens) {
                    LOG.debugf("Forcing acquisition of new tokens for client %s", (Object)currentState.tokens.getClientId());
                    newState = new TokenRequestState(this.prepareUni(oidcClient.getTokens(additionalParameters)));
                    if (!tokenRequestStateUpdater.compareAndSet(this, currentState, newState)) continue;
                    return newState.tokenUni;
                }
                tokens = currentState.tokens;
                if (!tokens.isAccessTokenExpired() && !tokens.isAccessTokenWithinRefreshInterval()) break block5;
                LOG.debugf("Starting refreshing the tokens for client %s", (Object)tokens.getClientId());
                boolean bl = refreshTokenValid = tokens.getRefreshToken() != null && !tokens.isRefreshTokenExpired();
                if (!refreshTokenValid) {
                    LOG.debugf("Refresh token is not available or has expired, acquiring new tokens instead for client %s", (Object)tokens.getClientId());
                }
                if (tokenRequestStateUpdater.compareAndSet(this, currentState, newState = new TokenRequestState(this.prepareUni(refreshTokenValid ? oidcClient.refreshTokens(tokens.getRefreshToken(), additionalParameters) : oidcClient.getTokens(additionalParameters))))) break;
            }
            return newState.tokenUni;
        }
        return Uni.createFrom().item((Object)tokens);
    }

    private Uni<Tokens> prepareUni(Uni<Tokens> tokens) {
        return tokens.onItemOrFailure().invoke((BiConsumer)new BiConsumer<Tokens, Throwable>(){

            @Override
            public void accept(Tokens tokens, Throwable throwable) {
                if (tokens != null) {
                    tokenRequestStateUpdater.set(TokensHelper.this, new TokenRequestState(tokens));
                } else {
                    tokenRequestStateUpdater.set(TokensHelper.this, null);
                }
            }
        }).memoize().indefinitely();
    }

    static class TokenRequestState {
        final Tokens tokens;
        final Uni<Tokens> tokenUni;

        TokenRequestState(Tokens tokens) {
            this.tokens = tokens;
            this.tokenUni = null;
        }

        TokenRequestState(Uni<Tokens> tokensUni) {
            this.tokens = null;
            this.tokenUni = tokensUni;
        }
    }
}

