/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client;

import io.vertx.core.json.JsonObject;
import java.time.Duration;
import org.jboss.logging.Logger;

public class Tokens {
    private static final Logger LOG = Logger.getLogger(Tokens.class);
    private final String accessToken;
    private final Long accessTokenExpiresAt;
    private final Long refreshTokenTimeSkew;
    private final String refreshToken;
    final Long refreshTokenExpiresAt;
    private final JsonObject grantResponse;
    private final String clientId;

    public Tokens(String accessToken, Long accessTokenExpiresAt, Duration refreshTokenTimeSkewDuration, String refreshToken, Long refreshTokenExpiresAt, JsonObject grantResponse, String clientId) {
        this.accessToken = accessToken;
        this.accessTokenExpiresAt = accessTokenExpiresAt;
        this.refreshTokenTimeSkew = refreshTokenTimeSkewDuration == null ? null : Long.valueOf(refreshTokenTimeSkewDuration.getSeconds());
        this.refreshToken = refreshToken;
        this.refreshTokenExpiresAt = refreshTokenExpiresAt;
        this.grantResponse = grantResponse;
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String get(String propertyName) {
        return this.grantResponse.getString(propertyName);
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Long getAccessTokenExpiresAt() {
        return this.accessTokenExpiresAt;
    }

    public Long getRefreshTokenTimeSkew() {
        return this.refreshTokenTimeSkew;
    }

    public boolean isAccessTokenExpired() {
        return this.isExpired(this.accessTokenExpiresAt, true);
    }

    public boolean isRefreshTokenExpired() {
        return this.isExpired(this.refreshTokenExpiresAt, false);
    }

    public boolean isAccessTokenWithinRefreshInterval() {
        boolean proactiveRefresh;
        if (this.accessTokenExpiresAt == null || this.refreshTokenTimeSkew == null) {
            return false;
        }
        long nowSecs = System.currentTimeMillis() / 1000L;
        boolean bl = proactiveRefresh = nowSecs + this.refreshTokenTimeSkew > this.accessTokenExpiresAt;
        if (proactiveRefresh) {
            LOG.debugf("Access token is still valid but must be refreshed by client %s because it will expire in about %d seconds which is less than the refresh token time skew %d", (Object)this.clientId, (Object)(this.accessTokenExpiresAt - nowSecs), (Object)this.refreshTokenTimeSkew);
        }
        return proactiveRefresh;
    }

    private boolean isExpired(Long expiresAt, boolean accessToken) {
        boolean expired;
        if (expiresAt == null) {
            return false;
        }
        long nowSecs = System.currentTimeMillis() / 1000L;
        boolean bl = expired = nowSecs > expiresAt;
        if (expired) {
            if (accessToken) {
                LOG.debugf("Access token has expired and must be refreshed by client %s", (Object)this.clientId);
            } else {
                LOG.debugf("Refresh token for client %s has expired", (Object)this.clientId);
            }
        } else {
            long expiresIn = expiresAt - nowSecs;
            if (accessToken) {
                LOG.tracef("Access token for client %s is valid but will expire in about %d seconds", (Object)this.clientId, (Object)expiresIn);
            } else {
                LOG.tracef("Refresh token for client %s is valid but will expire in about %d seconds", (Object)this.clientId, (Object)expiresIn);
            }
        }
        return expired;
    }
}

