/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClients;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.client.runtime.OidcClientsConfig;
import io.quarkus.oidc.client.runtime.TokensHelper;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractTokensProducer {
    private OidcClient oidcClient;
    protected boolean earlyTokenAcquisition = true;
    @Inject
    public OidcClientsConfig oidcClientsConfig;
    final TokensHelper tokensHelper = new TokensHelper();

    @PostConstruct
    public void init() {
        Optional<String> clientId = Objects.requireNonNull(this.clientId(), "clientId must not be null");
        OidcClients oidcClients = (OidcClients)Arc.container().instance(OidcClients.class, new Annotation[0]).get();
        if (clientId.isPresent()) {
            this.oidcClient = Objects.requireNonNull(oidcClients.getClient(clientId.get()), "Unknown client");
            this.earlyTokenAcquisition = this.oidcClientsConfig.namedClients.get((Object)clientId.get()).earlyTokensAcquisition;
        } else {
            this.earlyTokenAcquisition = this.oidcClientsConfig.defaultClient.earlyTokensAcquisition;
            this.oidcClient = oidcClients.getClient();
        }
        this.initTokens();
    }

    protected void initTokens() {
        if (this.earlyTokenAcquisition) {
            this.tokensHelper.initTokens(this.oidcClient);
        }
    }

    public Uni<Tokens> getTokens() {
        return this.tokensHelper.getTokens(this.oidcClient);
    }

    public Tokens awaitTokens() {
        return (Tokens)this.getTokens().await().indefinitely();
    }

    protected Optional<String> clientId() {
        return Optional.empty();
    }
}

