/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigGroup
public class OidcCommonConfig {
    @ConfigItem
    public Optional<String> authServerUrl = Optional.empty();
    @ConfigItem(defaultValueDocumentation="true")
    public Optional<Boolean> discoveryEnabled = Optional.empty();
    @ConfigItem
    public Optional<String> tokenPath = Optional.empty();
    @ConfigItem
    public Optional<String> revokePath = Optional.empty();
    @ConfigItem
    public Optional<String> clientId = Optional.empty();
    @ConfigItem
    public Optional<Duration> connectionDelay = Optional.empty();
    @ConfigItem(defaultValue="3")
    public int connectionRetryCount = 3;
    @ConfigItem(defaultValue="10s")
    public Duration connectionTimeout = Duration.ofSeconds(10L);
    @ConfigItem(defaultValue="false")
    public boolean useBlockingDnsLookup;
    @ConfigItem
    public OptionalInt maxPoolSize = OptionalInt.empty();
    @ConfigItem
    public Credentials credentials = new Credentials();
    @ConfigItem
    public Proxy proxy = new Proxy();
    @ConfigItem
    public Tls tls = new Tls();

    public Optional<Duration> getConnectionDelay() {
        return this.connectionDelay;
    }

    public void setConnectionDelay(Duration connectionDelay) {
        this.connectionDelay = Optional.of(connectionDelay);
    }

    public Optional<String> getAuthServerUrl() {
        return this.authServerUrl;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = Optional.of(authServerUrl);
    }

    public Optional<String> getTokenPath() {
        return this.tokenPath;
    }

    public void setTokenPath(String tokenPath) {
        this.tokenPath = Optional.of(tokenPath);
    }

    public Optional<String> getRevokePath() {
        return this.revokePath;
    }

    public void setRevokePath(String revokePath) {
        this.revokePath = Optional.of(revokePath);
    }

    public Optional<String> getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = Optional.of(clientId);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public Optional<Boolean> isDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    public void setDiscoveryEnabled(boolean enabled) {
        this.discoveryEnabled = Optional.of(enabled);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public OptionalInt getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = OptionalInt.of(maxPoolSize);
    }

    @ConfigGroup
    public static class Credentials {
        @ConfigItem
        public Optional<String> secret = Optional.empty();
        @ConfigItem
        public Secret clientSecret = new Secret();
        @ConfigItem
        public Jwt jwt = new Jwt();

        public Optional<String> getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = Optional.of(secret);
        }

        public Secret getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(Secret clientSecret) {
            this.clientSecret = clientSecret;
        }

        public Jwt getJwt() {
            return this.jwt;
        }

        public void setJwt(Jwt jwt) {
            this.jwt = jwt;
        }

        @ConfigGroup
        public static class Secret {
            @ConfigItem
            public Optional<String> value = Optional.empty();
            @ConfigItem
            public Provider provider = new Provider();
            @ConfigItem
            public Optional<Method> method = Optional.empty();

            public Optional<String> getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = Optional.of(value);
            }

            public Optional<Method> getMethod() {
                return this.method;
            }

            public void setMethod(Method method) {
                this.method = Optional.of(method);
            }

            public Provider getSecretProvider() {
                return this.provider;
            }

            public void setSecretProvider(Provider secretProvider) {
                this.provider = secretProvider;
            }

            public static enum Method {
                BASIC,
                POST,
                POST_JWT,
                QUERY;

            }
        }

        @ConfigGroup
        public static class Jwt {
            @ConfigItem(defaultValue="client")
            public Source source = Source.CLIENT;
            @ConfigItem
            public Optional<String> secret = Optional.empty();
            @ConfigItem
            public Provider secretProvider = new Provider();
            @ConfigItem
            public Optional<String> keyFile = Optional.empty();
            @ConfigItem
            public Optional<String> keyStoreFile = Optional.empty();
            @ConfigItem
            public Optional<String> keyStorePassword;
            @ConfigItem
            public Optional<String> keyId = Optional.empty();
            @ConfigItem
            public Optional<String> keyPassword;
            @ConfigItem
            public Optional<String> audience = Optional.empty();
            @ConfigItem
            public Optional<String> tokenKeyId = Optional.empty();
            @ConfigItem
            public Optional<String> issuer = Optional.empty();
            @ConfigItem
            public Optional<String> subject = Optional.empty();
            @ConfigItem
            public Map<String, String> claims = new HashMap<String, String>();
            @ConfigItem
            public Optional<String> signatureAlgorithm = Optional.empty();
            @ConfigItem(defaultValue="10")
            public int lifespan = 10;

            public Optional<String> getSecret() {
                return this.secret;
            }

            public void setSecret(String secret) {
                this.secret = Optional.of(secret);
            }

            public int getLifespan() {
                return this.lifespan;
            }

            public void setLifespan(int lifespan) {
                this.lifespan = lifespan;
            }

            public Optional<String> getTokenKeyId() {
                return this.tokenKeyId;
            }

            public void setTokenKeyId(String tokenKeyId) {
                this.tokenKeyId = Optional.of(tokenKeyId);
            }

            public Provider getSecretProvider() {
                return this.secretProvider;
            }

            public void setSecretProvider(Provider secretProvider) {
                this.secretProvider = secretProvider;
            }

            public Optional<String> getSignatureAlgorithm() {
                return this.signatureAlgorithm;
            }

            public void setSignatureAlgorithm(String signatureAlgorithm) {
                this.signatureAlgorithm = Optional.of(signatureAlgorithm);
            }

            public Optional<String> getAudience() {
                return this.audience;
            }

            public void setAudience(String audience) {
                this.audience = Optional.of(audience);
            }

            public Optional<String> getKeyFile() {
                return this.keyFile;
            }

            public void setKeyFile(String keyFile) {
                this.keyFile = Optional.of(keyFile);
            }

            public Map<String, String> getClaims() {
                return this.claims;
            }

            public void setClaims(Map<String, String> claims) {
                this.claims = claims;
            }

            public Source getSource() {
                return this.source;
            }

            public void setSource(Source source) {
                this.source = source;
            }

            public static enum Source {
                CLIENT,
                BEARER;

            }
        }

        @ConfigGroup
        public static class Provider {
            @ConfigItem
            public Optional<String> name = Optional.empty();
            @ConfigItem
            public Optional<String> key = Optional.empty();

            public Optional<String> getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = Optional.of(name);
            }

            public Optional<String> getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = Optional.of(key);
            }
        }
    }

    @ConfigGroup
    public static class Proxy {
        @ConfigItem
        public Optional<String> host = Optional.empty();
        @ConfigItem(defaultValue="80")
        public int port = 80;
        @ConfigItem
        public Optional<String> username = Optional.empty();
        @ConfigItem
        public Optional<String> password = Optional.empty();
    }

    @ConfigGroup
    public static class Tls {
        @ConfigItem
        public Optional<Verification> verification = Optional.empty();
        @ConfigItem
        public Optional<Path> keyStoreFile = Optional.empty();
        @ConfigItem
        public Optional<String> keyStoreFileType = Optional.empty();
        @ConfigItem
        public Optional<String> keyStoreProvider;
        @ConfigItem
        public Optional<String> keyStorePassword;
        @ConfigItem
        public Optional<String> keyStoreKeyAlias = Optional.empty();
        @ConfigItem
        public Optional<String> keyStoreKeyPassword = Optional.empty();
        @ConfigItem
        public Optional<Path> trustStoreFile = Optional.empty();
        @ConfigItem
        public Optional<String> trustStorePassword = Optional.empty();
        @ConfigItem
        public Optional<String> trustStoreCertAlias = Optional.empty();
        @ConfigItem
        public Optional<String> trustStoreFileType = Optional.empty();
        @ConfigItem
        public Optional<String> trustStoreProvider;

        public Optional<Verification> getVerification() {
            return this.verification;
        }

        public void setVerification(Verification verification) {
            this.verification = Optional.of(verification);
        }

        public Optional<Path> getTrustStoreFile() {
            return this.trustStoreFile;
        }

        public void setTrustStoreFile(Path trustStoreFile) {
            this.trustStoreFile = Optional.of(trustStoreFile);
        }

        public Optional<String> getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = Optional.of(trustStorePassword);
        }

        public Optional<String> getTrustStoreCertAlias() {
            return this.trustStoreCertAlias;
        }

        public void setTrustStoreCertAlias(String trustStoreCertAlias) {
            this.trustStoreCertAlias = Optional.of(trustStoreCertAlias);
        }

        public Optional<String> getKeyStoreProvider() {
            return this.keyStoreProvider;
        }

        public void setKeyStoreProvider(String keyStoreProvider) {
            this.keyStoreProvider = Optional.of(keyStoreProvider);
        }

        public Optional<String> getTrustStoreProvider() {
            return this.trustStoreProvider;
        }

        public void setTrustStoreProvider(String trustStoreProvider) {
            this.trustStoreProvider = Optional.of(trustStoreProvider);
        }

        public static enum Verification {
            REQUIRED,
            CERTIFICATE_VALIDATION,
            NONE;

        }
    }
}

