/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices.keycloak;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.devservices.keycloak.KeycloakDevServicesConfigBuildItem;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.oidc.deployment.DevUiConfig;
import io.quarkus.oidc.deployment.OidcBuildTimeConfig;
import io.quarkus.oidc.deployment.devservices.AbstractDevUIProcessor;
import io.quarkus.oidc.runtime.devui.OidcDevJsonRpcService;
import io.quarkus.oidc.runtime.devui.OidcDevUiRecorder;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class KeycloakDevUIProcessor
extends AbstractDevUIProcessor {
    OidcBuildTimeConfig oidcConfig;

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    void produceProviderComponent(Optional<KeycloakDevServicesConfigBuildItem> configProps, BuildProducer<CardPageBuildItem> cardPageProducer, OidcDevUiRecorder recorder, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, ConfigurationBuildItem configurationBuildItem, Capabilities capabilities) {
        if (configProps.isPresent() && configProps.get().getConfig().containsKey("keycloak.url")) {
            String realmUrl = (String)configProps.get().getConfig().get("quarkus.oidc.auth-server-url");
            Map users = (Map)configProps.get().getProperties().get("oidc.users");
            String keycloakAdminUrl = (String)configProps.get().getConfig().get("keycloak.url");
            List keycloakRealms = (List)configProps.get().getProperties().get("keycloak.realms");
            CardPageBuildItem cardPageBuildItem = KeycloakDevUIProcessor.createProviderWebComponent(recorder, capabilities, "Keycloak", (String)configProps.get().getConfig().get("quarkus.oidc.application-type"), this.oidcConfig.devui.grant.type.orElse(DevUiConfig.Grant.Type.CODE).getGrantType(), realmUrl + "/protocol/openid-connect/auth", realmUrl + "/protocol/openid-connect/token", realmUrl + "/protocol/openid-connect/logout", true, syntheticBeanBuildItemBuildProducer, this.oidcConfig.devui.webClientTimeout, this.oidcConfig.devui.grantOptions, nonApplicationRootPathBuildItem, configurationBuildItem, keycloakAdminUrl, users, keycloakRealms, configProps.get().isContainerRestarted());
            cardPageBuildItem.addPage((PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"Keycloak Admin").icon("font-awesome-solid:key")).doNotEmbed(true).url(keycloakAdminUrl));
            cardPageProducer.produce((BuildItem)cardPageBuildItem);
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    JsonRPCProvidersBuildItem produceOidcDevJsonRpcService() {
        return new JsonRPCProvidersBuildItem(OidcDevJsonRpcService.class);
    }
}

