/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.quarkus.oidc.runtime.AbstractJsonObjectResponse;
import jakarta.json.JsonObject;
import org.eclipse.microprofile.jwt.Claims;

public class UserInfo
extends AbstractJsonObjectResponse {
    private static final String EMAIL = "email";
    private static final String NAME = "name";
    private static final String FIRST_NAME = "first_name";
    private static final String FAMILY_NAME = "family_name";
    private static final String DISPLAY_NAME = "display_name";

    public UserInfo() {
    }

    public UserInfo(String userInfoJson) {
        super(userInfoJson);
    }

    public UserInfo(JsonObject json) {
        super(json);
    }

    public String getUserInfoString() {
        return this.getNonNullJsonString();
    }

    public String getName() {
        return this.getString(NAME);
    }

    public String getFirstName() {
        return this.getString(FIRST_NAME);
    }

    public String getFamilyName() {
        return this.getString(FAMILY_NAME);
    }

    public String getDisplayName() {
        return this.getString(DISPLAY_NAME);
    }

    public String getPreferredUserName() {
        return this.getString(Claims.preferred_username.name());
    }

    public String getSubject() {
        return this.getString(Claims.sub.name());
    }

    public String getEmail() {
        return this.getString(EMAIL);
    }
}

