/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.deployment;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.transformer.action.ActionContext;
import org.eclipse.transformer.action.ByteData;
import org.eclipse.transformer.action.SelectionRule;
import org.eclipse.transformer.action.SignatureRule;
import org.eclipse.transformer.action.impl.ActionContextImpl;
import org.eclipse.transformer.action.impl.ByteDataImpl;
import org.eclipse.transformer.action.impl.ClassActionImpl;
import org.eclipse.transformer.action.impl.SelectionRuleImpl;
import org.eclipse.transformer.action.impl.SignatureRuleImpl;
import org.eclipse.transformer.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaEnablement {
    private static final List<String> CLASSES_NEEDING_TRANSFORMATION = List.of("org.quartz.ExecuteInJTATransaction", "org.quartz.ee.servlet.QuartzInitializerServlet", "org.quartz.ee.servlet.QuartzInitializerListener", "org.quartz.ee.jta.JTAJobRunShell", "org.quartz.ee.jta.UserTransactionHelper", "org.quartz.ee.jta.UserTransactionHelper$UserTransactionWithContext", "org.quartz.xml.XMLSchedulingDataProcessor", "org.quartz.impl.jdbcjobstore.JTANonClusteredSemaphore");

    @BuildStep
    void transformToJakarta(BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"jakarta.transaction.Transaction")) {
            JakartaTransformer tr = new JakartaTransformer();
            for (String classname : CLASSES_NEEDING_TRANSFORMATION) {
                BytecodeTransformerBuildItem item = new BytecodeTransformerBuildItem.Builder().setCacheable(true).setContinueOnFailure(false).setClassToTransform(classname).setClassReaderOptions(2).setInputTransformer(tr::transform).build();
                transformers.produce((BuildItem)item);
            }
        }
    }

    private static class JakartaTransformer {
        private final Logger logger = LoggerFactory.getLogger((String)"JakartaTransformer");
        private final ActionContext ctx = new ActionContextImpl(this.logger, (SelectionRule)new SelectionRuleImpl(this.logger, Collections.emptyMap(), Collections.emptyMap()), (SignatureRule)new SignatureRuleImpl(this.logger, renames, null, null, null, null, null, Collections.emptyMap()));
        private static final Map<String, String> renames = Map.of("javax.transaction", "jakarta.transaction", "javax.servlet", "jakarta.servlet", "javax.xml.bind", "jakarta.xml.bind");

        JakartaTransformer() {
        }

        byte[] transform(String name, byte[] bytes) {
            this.logger.debug("Jakarta EE compatibility enhancer for Quarkus: transforming " + name);
            ClassActionImpl classTransformer = new ClassActionImpl(this.ctx);
            ByteBuffer input = ByteBuffer.wrap(bytes);
            ByteDataImpl inputData = new ByteDataImpl(name, input, FileUtils.DEFAULT_CHARSET);
            ByteData outputData = classTransformer.apply((ByteData)inputData);
            return outputData.buffer().array();
        }
    }
}

