/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.runtime;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

class CdiAwareJob
implements InterruptableJob {
    private final Instance.Handle<? extends Job> handle;
    private final Job beanInstance;

    public CdiAwareJob(Instance.Handle<? extends Job> handle) {
        this.handle = handle;
        this.beanInstance = (Job)handle.get();
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        boolean refire = false;
        try {
            this.beanInstance.execute(context);
        }
        catch (JobExecutionException e) {
            refire = e.refireImmediately();
            throw e;
        }
        finally {
            if (!refire && this.handle.getBean().getScope().equals(Dependent.class)) {
                this.handle.destroy();
            }
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
        if (!InterruptableJob.class.isAssignableFrom(this.handle.getBean().getBeanClass())) {
            throw new UnableToInterruptJobException("Job " + this.handle.getBean().getBeanClass() + " can not be interrupted, since it does not implement " + InterruptableJob.class.getName());
        }
        ((InterruptableJob)this.beanInstance).interrupt();
    }
}

