/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config;

import io.quarkus.restclient.config.AbstractRestClientConfigBuilder;
import io.quarkus.restclient.config.RegisteredRestClient;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithDefaults;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;

@ConfigMapping(prefix="quarkus.rest-client")
@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public interface RestClientsBuildTimeConfig {
    @WithParentName
    @WithDefaults
    public Map<String, RestClientBuildConfig> clients();

    @WithName(value="removes-trailing-slash")
    @WithDefault(value="true")
    public boolean removesTrailingSlash();

    default public RestClientsBuildTimeConfig get(List<RegisteredRestClient> restClients) {
        return (RestClientsBuildTimeConfig)this.getConfig(restClients).getConfigMapping(RestClientsBuildTimeConfig.class);
    }

    default public SmallRyeConfig getConfig(final List<RegisteredRestClient> restClients) {
        return new SmallRyeConfigBuilder().withSources(new ConfigSource[]{new ConfigSource(){
            final SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
            final ConfigSource defaultsSource = this.getDefaultsSource();

            public Set<String> getPropertyNames() {
                HashSet<String> properties = new HashSet<String>();
                this.config.getPropertyNames().forEach(properties::add);
                return properties;
            }

            public String getValue(String propertyName) {
                ConfigValue configValue = this.config.getConfigValue(propertyName);
                if (configValue != null && !this.defaultsSource.getName().equals(configValue.getSourceName())) {
                    return configValue.getValue();
                }
                return null;
            }

            public String getName() {
                return "SmallRye Config";
            }

            private ConfigSource getDefaultsSource() {
                ConfigSource configSource = null;
                Iterator iterator = this.config.getConfigSources().iterator();
                while (iterator.hasNext()) {
                    ConfigSource source;
                    configSource = source = (ConfigSource)iterator.next();
                }
                return configSource;
            }
        }}).withCustomizers(new SmallRyeConfigBuilderCustomizer[]{new SmallRyeConfigBuilderCustomizer(){

            public void configBuilder(SmallRyeConfigBuilder builder) {
                new AbstractRestClientConfigBuilder(false){

                    @Override
                    public List<RegisteredRestClient> getRestClients() {
                        return restClients;
                    }
                }.configBuilder(builder);
            }
        }}).withMapping(RestClientsBuildTimeConfig.class).withMappingIgnore("quarkus.**").build();
    }

    public static interface RestClientBuildConfig {
        public Optional<String> scope();

        @WithDefault(value="false")
        public boolean enableLocalProxy();

        public Optional<String> localProxyProvider();

        @WithName(value="removes-trailing-slash")
        @WithDefault(value="true")
        public boolean removesTrailingSlash();
    }
}

