/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.quarkus.resteasy.reactive.jackson.runtime.ResteasyReactiveServerJacksonRecorder;
import jakarta.inject.Singleton;
import java.lang.reflect.InvocationTargetException;

@Singleton
public class GeneratedSerializersRegister
implements ObjectMapperCustomizer {
    public void customize(ObjectMapper objectMapper) {
        objectMapper.registerModule((Module)MappingModuleHolder.mappingModule);
    }

    static class MappingModuleHolder {
        static final SimpleModule mappingModule = MappingModuleHolder.createMappingModule();

        MappingModuleHolder() {
        }

        private static SimpleModule createMappingModule() {
            SimpleModule module = new SimpleModule();
            for (Class<? extends StdSerializer> clazz : ResteasyReactiveServerJacksonRecorder.getGeneratedSerializers()) {
                try {
                    StdSerializer serializer = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    module.addSerializer(serializer.handledType(), (JsonSerializer)serializer);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            for (Class<? extends StdSerializer> clazz : ResteasyReactiveServerJacksonRecorder.getGeneratedDeserializers()) {
                try {
                    StdDeserializer deserializer = (StdDeserializer)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    module.addDeserializer(deserializer.handledType(), (JsonDeserializer)deserializer);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return module;
        }
    }
}

