/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.runtime.devui;

import io.quarkus.scheduler.FailedExecution;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.ScheduledJobPaused;
import io.quarkus.scheduler.ScheduledJobResumed;
import io.quarkus.scheduler.Scheduler;
import io.quarkus.scheduler.SchedulerPaused;
import io.quarkus.scheduler.SchedulerResumed;
import io.quarkus.scheduler.SuccessfulExecution;
import io.quarkus.scheduler.Trigger;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import io.quarkus.scheduler.common.runtime.ScheduledMethod;
import io.quarkus.scheduler.common.runtime.SchedulerContext;
import io.quarkus.scheduler.common.runtime.util.SchedulerUtils;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import java.time.Instant;
import java.time.LocalDateTime;
import org.jboss.logging.Logger;

@ApplicationScoped
public class SchedulerJsonRPCService {
    private static final Logger LOG = Logger.getLogger(SchedulerJsonRPCService.class);
    private static final String SCHEDULER_ID = "quarkus_scheduler";
    private final BroadcastProcessor<JsonObject> runningStatus = BroadcastProcessor.create();
    private final BroadcastProcessor<JsonObject> log = BroadcastProcessor.create();
    private final Instance<SchedulerContext> context;
    private final Instance<Scheduler> scheduler;
    private final Instance<Vertx> vertx;

    public SchedulerJsonRPCService(Instance<SchedulerContext> context, Instance<Scheduler> scheduler, Instance<Vertx> vertx) {
        this.context = context;
        this.scheduler = scheduler;
        this.vertx = vertx;
    }

    void onPause(@Observes SchedulerPaused e) {
        this.runningStatus.onNext((Object)this.newRunningStatus(SCHEDULER_ID, false));
    }

    void onResume(@Observes SchedulerResumed e) {
        this.runningStatus.onNext((Object)this.newRunningStatus(SCHEDULER_ID, true));
    }

    void onPause(@Observes ScheduledJobPaused e) {
        this.runningStatus.onNext((Object)this.newRunningStatus(e.getTrigger().getId(), false));
    }

    void onResume(@Observes ScheduledJobResumed e) {
        this.runningStatus.onNext((Object)this.newRunningStatus(e.getTrigger().getId(), true));
    }

    void onJobSuccess(@Observes SuccessfulExecution e) {
        this.log.onNext((Object)this.newExecutionLog(e.getExecution().getTrigger(), true, null, this.isUserDefinedIdentity(e.getExecution().getTrigger().getId())));
    }

    void onJobFailure(@Observes FailedExecution e) {
        this.log.onNext((Object)this.newExecutionLog(e.getExecution().getTrigger(), false, e.getException().getMessage(), this.isUserDefinedIdentity(e.getExecution().getTrigger().getId())));
    }

    public Multi<JsonObject> streamLog() {
        return this.log;
    }

    public Multi<JsonObject> streamRunningStatus() {
        return this.runningStatus;
    }

    @NonBlocking
    public JsonObject getData() {
        SchedulerContext c = (SchedulerContext)this.context.get();
        Scheduler s = (Scheduler)this.scheduler.get();
        JsonObject ret = new JsonObject();
        ret.put("schedulerRunning", (Object)s.isRunning());
        JsonArray methodsJson = new JsonArray();
        ret.put("methods", (Object)methodsJson);
        for (ScheduledMethod metadata : c.getScheduledMethods()) {
            JsonObject methodJson = new JsonObject();
            methodJson.put("declaringClassName", (Object)metadata.getDeclaringClassName());
            methodJson.put("methodName", (Object)metadata.getMethodName());
            methodJson.put("methodDescription", (Object)metadata.getMethodDescription());
            JsonArray schedulesJson = new JsonArray();
            for (Scheduled schedule : metadata.getSchedules()) {
                String cron;
                JsonObject scheduleJson = new JsonObject();
                if (!schedule.identity().isBlank()) {
                    this.putConfigLookup("identity", schedule.identity(), scheduleJson);
                    scheduleJson.put("running", (Object)(!s.isPaused(schedule.identity()) ? 1 : 0));
                }
                if (!(cron = schedule.cron()).isBlank()) {
                    this.putConfigLookup("cron", cron, scheduleJson);
                } else {
                    this.putConfigLookup("every", schedule.every(), scheduleJson);
                }
                if (schedule.delay() > 0L) {
                    scheduleJson.put("delay", (Object)schedule.delay());
                    scheduleJson.put("delayUnit", (Object)schedule.delayUnit().toString().toLowerCase());
                } else if (!schedule.delayed().isBlank()) {
                    this.putConfigLookup("delayed", schedule.delayed(), scheduleJson);
                }
                schedulesJson.add((Object)scheduleJson);
            }
            methodJson.put("schedules", (Object)schedulesJson);
            methodsJson.add((Object)methodJson);
        }
        return ret;
    }

    @NonBlocking
    public JsonObject pauseScheduler() {
        Scheduler s = (Scheduler)this.scheduler.get();
        if (!s.isRunning()) {
            return this.newFailure("Scheduler is already paused");
        }
        s.pause();
        LOG.info((Object)"Scheduler paused via Dev UI");
        return this.newSuccess("Scheduler was paused");
    }

    @NonBlocking
    public JsonObject resumeScheduler() {
        Scheduler s = (Scheduler)this.scheduler.get();
        if (s.isRunning()) {
            return this.newFailure("Scheduler is already running");
        }
        s.resume();
        LOG.info((Object)"Scheduler resumed via Dev UI");
        return this.newSuccess("Scheduler was resumed");
    }

    @NonBlocking
    public JsonObject pauseJob(String identity) {
        Scheduler s = (Scheduler)this.scheduler.get();
        if (s.isPaused(identity)) {
            return this.newFailure("Job with identity " + identity + " is already paused");
        }
        s.pause(identity);
        LOG.infof("Paused job with identity '%s' via Dev UI", (Object)identity);
        return this.newSuccess("Job with identity " + identity + " was paused");
    }

    @NonBlocking
    public JsonObject resumeJob(String identity) {
        Scheduler s = (Scheduler)this.scheduler.get();
        if (!s.isPaused(identity)) {
            return this.newFailure("Job with identity " + identity + " is not paused");
        }
        s.resume(identity);
        LOG.infof("Resumed job with identity '%s' via Dev UI", (Object)identity);
        return this.newSuccess("Job with identity " + identity + " was resumed");
    }

    @NonBlocking
    public JsonObject executeJob(String methodDescription) {
        SchedulerContext c = (SchedulerContext)this.context.get();
        for (ScheduledMethod metadata : c.getScheduledMethods()) {
            if (!metadata.getMethodDescription().equals(methodDescription)) continue;
            Context vdc = VertxContext.getOrCreateDuplicatedContext((Vertx)((Vertx)this.vertx.get()));
            VertxContextSafetyToggle.setContextSafe((Context)vdc, (boolean)true);
            try {
                ScheduledInvoker invoker = c.createInvoker(metadata.getInvokerClassName());
                if (invoker.isBlocking()) {
                    vdc.executeBlocking(p -> {
                        try {
                            invoker.invoke((ScheduledExecution)new DevUIScheduledExecution());
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            p.complete();
                        }
                    }, false);
                } else {
                    vdc.runOnContext(x -> {
                        try {
                            invoker.invoke((ScheduledExecution)new DevUIScheduledExecution());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
                LOG.infof("Invoked scheduled method %s via Dev UI", (Object)methodDescription);
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to invoke a @Scheduled method: " + metadata.getMethodDescription()), (Throwable)e);
            }
            return this.newSuccess("Invoked scheduled method " + methodDescription + " via Dev UI");
        }
        return this.newFailure("Scheduled method not found " + methodDescription);
    }

    private JsonObject newSuccess(String message) {
        return new JsonObject().put("success", (Object)true).put("message", (Object)message);
    }

    private JsonObject newFailure(String message) {
        return new JsonObject().put("success", (Object)false).put("message", (Object)message);
    }

    private JsonObject newRunningStatus(String id, boolean running) {
        return new JsonObject().put("id", (Object)id).put("running", (Object)running);
    }

    private JsonObject newExecutionLog(Trigger trigger, boolean success, String message, boolean userDefinedIdentity) {
        JsonObject log = new JsonObject().put("timestamp", (Object)LocalDateTime.now().toString()).put("success", (Object)success);
        String description = trigger.getMethodDescription();
        if (description != null) {
            log.put("triggerMethodDescription", (Object)description);
            if (userDefinedIdentity) {
                log.put("triggerIdentity", (Object)trigger.getId());
            }
        } else {
            log.put("triggerIdentity", (Object)trigger.getId());
        }
        if (message != null) {
            log.put("message", (Object)message);
        }
        return log;
    }

    private boolean isUserDefinedIdentity(String identity) {
        for (ScheduledMethod metadata : ((SchedulerContext)this.context.get()).getScheduledMethods()) {
            for (Scheduled schedule : metadata.getSchedules()) {
                if (!identity.equals(schedule.identity())) continue;
                return true;
            }
        }
        return false;
    }

    private void putConfigLookup(String key, String value, JsonObject scheduleJson) {
        scheduleJson.put(key, (Object)value);
        String configLookup = SchedulerUtils.lookUpPropertyValue((String)value);
        if (!value.equals(configLookup)) {
            scheduleJson.put(key + "Config", (Object)configLookup);
        }
    }

    private static class DevUIScheduledExecution
    implements ScheduledExecution {
        private final Instant now = Instant.now();

        DevUIScheduledExecution() {
        }

        public Trigger getTrigger() {
            return new Trigger(){

                public String getId() {
                    return "dev-console";
                }

                public Instant getNextFireTime() {
                    return null;
                }

                public Instant getPreviousFireTime() {
                    return now;
                }

                public boolean isOverdue() {
                    return false;
                }
            };
        }

        public Instant getFireTime() {
            return this.now;
        }

        public Instant getScheduledFireTime() {
            return this.now;
        }
    }
}

