/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.arc.DefaultBean;
import io.quarkus.runtime.ExecutorRecorder;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.runtime.AnonymousIdentityProvider;
import io.quarkus.security.runtime.QuarkusIdentityProviderManagerImpl;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@ApplicationScoped
public class IdentityProviderManagerCreator {
    @Inject
    Instance<IdentityProvider<?>> identityProviders;
    @Inject
    Instance<SecurityIdentityAugmentor> augmentors;
    @Inject
    BlockingSecurityExecutor blockingExecutor;

    @ApplicationScoped
    @DefaultBean
    @Produces
    BlockingSecurityExecutor defaultBlockingExecutor() {
        return BlockingSecurityExecutor.createBlockingExecutor((Supplier)new Supplier<Executor>(){

            @Override
            public Executor get() {
                return ExecutorRecorder.getCurrent();
            }
        });
    }

    @Produces
    @ApplicationScoped
    public IdentityProviderManager ipm() {
        boolean customAnon = false;
        QuarkusIdentityProviderManagerImpl.Builder builder = QuarkusIdentityProviderManagerImpl.builder();
        for (IdentityProvider i : this.identityProviders) {
            builder.addProvider((IdentityProvider<? extends AuthenticationRequest>)i);
            if (i.getRequestType() != AnonymousAuthenticationRequest.class) continue;
            customAnon = true;
        }
        if (!customAnon) {
            builder.addProvider(new AnonymousIdentityProvider());
        }
        for (IdentityProvider i : this.augmentors) {
            builder.addSecurityIdentityAugmentor((SecurityIdentityAugmentor)i);
        }
        builder.setBlockingExecutor(this.blockingExecutor);
        return builder.build();
    }
}

