/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime.spi.datafetcher;

import graphql.schema.DataFetchingEnvironment;
import io.quarkus.arc.Arc;
import io.quarkus.smallrye.graphql.runtime.spi.datafetcher.AbstractAsyncDataFetcher;
import io.quarkus.smallrye.graphql.runtime.spi.datafetcher.BlockingHelper;
import io.smallrye.context.SmallRyeThreadContext;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;

public class QuarkusUniDataFetcher<K, T>
extends AbstractAsyncDataFetcher<K, T> {
    public QuarkusUniDataFetcher(Operation operation, Type type) {
        super(operation, type);
    }

    @Override
    protected Uni<?> handleUserMethodCall(DataFetchingEnvironment dfe, Object[] transformedArguments) throws Exception {
        Context vc = Vertx.currentContext();
        if (this.runBlocking(dfe) || !BlockingHelper.nonBlockingShouldExecuteBlocking(this.operation, vc)) {
            return this.handleUserMethodCallNonBlocking(transformedArguments);
        }
        return this.handleUserMethodCallBlocking(transformedArguments, vc);
    }

    @Override
    protected Uni<List<T>> handleUserBatchLoad(DataFetchingEnvironment dfe, Object[] arguments) throws Exception {
        Context vc = Vertx.currentContext();
        if (this.runBlocking(dfe) || !BlockingHelper.nonBlockingShouldExecuteBlocking(this.operation, vc)) {
            return this.handleUserBatchLoadNonBlocking(arguments);
        }
        return this.handleUserBatchLoadBlocking(arguments, vc);
    }

    private Uni<?> handleUserMethodCallNonBlocking(Object[] transformedArguments) throws Exception {
        return (Uni)this.operationInvoker.invoke(transformedArguments);
    }

    private Uni<?> handleUserMethodCallBlocking(Object[] transformedArguments, Context vc) throws Exception {
        SmallRyeThreadContext threadContext = (SmallRyeThreadContext)Arc.container().select(SmallRyeThreadContext.class, new Annotation[0]).get();
        Promise result = Promise.promise();
        Callable contextualCallable = threadContext.contextualCallable(() -> {
            Object resultFromMethodCall = this.operationInvoker.invoke(transformedArguments);
            Uni uniFromMethodCall = (Uni)resultFromMethodCall;
            return uniFromMethodCall.subscribeAsCompletionStage().get();
        });
        BlockingHelper.runBlocking(vc, contextualCallable, result);
        return Uni.createFrom().completionStage(result.future().toCompletionStage());
    }

    protected Uni<List<T>> handleUserBatchLoadNonBlocking(Object[] arguments) throws Exception {
        return (Uni)this.operationInvoker.invoke(arguments);
    }

    private Uni<List<T>> handleUserBatchLoadBlocking(Object[] arguments, Context vc) throws Exception {
        SmallRyeThreadContext threadContext = (SmallRyeThreadContext)Arc.container().select(SmallRyeThreadContext.class, new Annotation[0]).get();
        Promise result = Promise.promise();
        Callable contextualCallable = threadContext.contextualCallable(() -> {
            Object resultFromMethodCall = this.operationInvoker.invoke(arguments);
            Uni uniFromMethodCall = (Uni)resultFromMethodCall;
            return uniFromMethodCall.subscribeAsCompletionStage().get();
        });
        BlockingHelper.runBlocking(vc, contextualCallable, result);
        return Uni.createFrom().completionStage(result.future().toCompletionStage());
    }

    private boolean runBlocking(DataFetchingEnvironment dfe) {
        return (Boolean)dfe.getGraphQlContext().get((Object)"runBlocking");
    }
}

