/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime.spi.datafetcher;

import graphql.GraphQLError;
import graphql.execution.AbortExecutionException;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.smallrye.graphql.runtime.spi.datafetcher.BlockingHelper;
import io.quarkus.smallrye.graphql.runtime.spi.datafetcher.RequestContextHelper;
import io.smallrye.context.SmallRyeThreadContext;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.execution.context.SmallRyeContextManager;
import io.smallrye.graphql.execution.datafetcher.DefaultDataFetcher;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.smallrye.graphql.validation.BeanValidationUtil;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import jakarta.validation.ConstraintViolationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.eclipse.microprofile.graphql.GraphQLException;

public class QuarkusDefaultDataFetcher<K, T>
extends DefaultDataFetcher<K, T> {
    public QuarkusDefaultDataFetcher(Operation operation, Type type) {
        super(operation, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T invokeAndTransform(Context c, DataFetchingEnvironment dfe, DataFetcherResult.Builder<Object> resultBuilder, Object[] transformedArguments) throws Exception {
        ManagedContext requestContext = Arc.container().requestContext();
        try {
            RequestContextHelper.reactivate(requestContext, dfe);
            io.vertx.core.Context vc = Vertx.currentContext();
            if (this.runBlocking(dfe) || BlockingHelper.blockingShouldExecuteNonBlocking(this.operation, vc)) {
                Object object = super.invokeAndTransform(c, dfe, resultBuilder, transformedArguments);
                return (T)object;
            }
            T t = this.invokeAndTransformBlocking(c, dfe, resultBuilder, transformedArguments, vc);
            return t;
        }
        finally {
            this.deactivate(requestContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<List<T>> invokeBatch(DataFetchingEnvironment dfe, Object[] arguments) {
        ManagedContext requestContext = Arc.container().requestContext();
        try {
            RequestContextHelper.reactivate(requestContext, dfe);
            io.vertx.core.Context vc = Vertx.currentContext();
            if (this.runBlocking(dfe) || BlockingHelper.blockingShouldExecuteNonBlocking(this.operation, vc)) {
                CompletionStage completionStage = super.invokeBatch(dfe, arguments);
                return completionStage;
            }
            CompletionStage<List<T>> completionStage = this.invokeBatchBlocking(dfe, arguments, vc);
            return completionStage;
        }
        finally {
            this.deactivate(requestContext);
        }
    }

    private <T> T invokeAndTransformBlocking(Context c, DataFetchingEnvironment dfe, DataFetcherResult.Builder<Object> resultBuilder, Object[] transformedArguments, io.vertx.core.Context vc) throws Exception {
        SmallRyeThreadContext threadContext = (SmallRyeThreadContext)Arc.container().select(SmallRyeThreadContext.class, new Annotation[0]).get();
        Promise result = Promise.promise();
        this.measurementIds.add(this.metricsEmitter.start(c));
        Callable contextualCallable = threadContext.contextualCallable(() -> {
            try {
                Object resultFromMethodCall = this.operationInvoker.invoke(transformedArguments);
                Object resultFromTransform = this.fieldHelper.transformOrAdaptResponse(resultFromMethodCall, dfe);
                resultBuilder.data(resultFromTransform);
                return resultBuilder.build();
            }
            catch (AbstractDataFetcherException te) {
                te.appendDataFetcherResult(resultBuilder, dfe);
                return resultBuilder.build();
            }
            catch (GraphQLException graphQLException) {
                this.errorResultHelper.appendPartialResult(resultBuilder, dfe, graphQLException);
                return resultBuilder.build();
            }
            catch (Error e) {
                resultBuilder.clearErrors().data(null).error((GraphQLError)new AbortExecutionException((Throwable)e));
                return resultBuilder.build();
            }
            catch (ConstraintViolationException cve) {
                BeanValidationUtil.addConstraintViolationsToDataFetcherResult((Set)cve.getConstraintViolations(), (Method)this.operationInvoker.getMethod(), (DataFetcherResult.Builder)resultBuilder, (DataFetchingEnvironment)dfe);
                return resultBuilder.build();
            }
            catch (Throwable ex) {
                throw ex;
            }
        });
        BlockingHelper.runBlocking(vc, contextualCallable, result);
        return (T)Uni.createFrom().completionStage(result.future().toCompletionStage()).onItemOrFailure().invoke((item, error) -> {
            if (item != null) {
                this.eventEmitter.fireAfterDataFetch(c);
                this.metricsEmitter.end((Long)this.measurementIds.remove());
            } else {
                this.eventEmitter.fireOnDataFetchError(c, error);
            }
        }).subscribeAsCompletionStage();
    }

    private CompletionStage<List<T>> invokeBatchBlocking(DataFetchingEnvironment dfe, Object[] arguments, io.vertx.core.Context vc) {
        SmallRyeThreadContext threadContext = (SmallRyeThreadContext)Arc.container().select(SmallRyeThreadContext.class, new Annotation[0]).get();
        Promise result = Promise.promise();
        Callable contextualCallable = threadContext.contextualCallable(() -> (List)this.operationInvoker.invokePrivileged(arguments));
        Consumer onErrorConsumer = threadContext.contextualConsumer(exception -> {
            Context context = (Context)dfe.getGraphQlContext().get((Object)"context");
            this.eventEmitter.fireOnDataFetchError(context, exception);
        });
        BlockingHelper.runBlocking(vc, contextualCallable, result);
        return result.future().toCompletionStage().whenComplete((resultList, error) -> {
            if (error != null) {
                onErrorConsumer.accept(error);
            }
        });
    }

    private boolean runBlocking(DataFetchingEnvironment dfe) {
        return (Boolean)dfe.getGraphQlContext().get((Object)"runBlocking");
    }

    private void deactivate(ManagedContext requestContext) {
        SmallRyeContextManager.clearCurrentSmallRyeContext();
        requestContext.deactivate();
    }
}

