/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.jwt.auth.principal.JWTParser;
import io.smallrye.jwt.auth.principal.ParseException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.security.Principal;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;

@ApplicationScoped
public class MpJwtValidator
implements IdentityProvider<TokenAuthenticationRequest> {
    private static final Logger log = Logger.getLogger(MpJwtValidator.class);
    final JWTParser parser;

    public MpJwtValidator() {
        this.parser = null;
    }

    @Inject
    public MpJwtValidator(JWTParser parser) {
        this.parser = parser;
    }

    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(final TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super SecurityIdentity>>(){

            @Override
            public void accept(UniEmitter<? super SecurityIdentity> uniEmitter) {
                try {
                    JsonWebToken jwtPrincipal = MpJwtValidator.this.parser.parse(request.getToken().getToken());
                    uniEmitter.complete((Object)QuarkusSecurityIdentity.builder().setPrincipal((Principal)jwtPrincipal).addRoles(jwtPrincipal.getGroups()).addAttribute("quarkus.user", (Object)jwtPrincipal).build());
                }
                catch (ParseException e) {
                    log.debug((Object)"Authentication failed", (Throwable)e);
                    uniEmitter.fail((Throwable)new AuthenticationFailedException((Throwable)e));
                }
            }
        });
    }
}

