/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.amazon.lambda.test.LambdaException;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;

public class LambdaClient {
    private static final AtomicInteger REQUEST_ID_GENERATOR = new AtomicInteger();
    public static final ConcurrentHashMap<String, CompletableFuture<String>> REQUESTS;
    public static final LinkedBlockingDeque<Map.Entry<String, String>> REQUEST_QUEUE;
    static volatile LambdaException problem;

    public static void invoke(InputStream inputStream, OutputStream outputStream) {
        if (problem != null) {
            throw new RuntimeException(problem);
        }
        try {
            final String id = "aws-request-" + REQUEST_ID_GENERATOR.incrementAndGet();
            CompletableFuture result = new CompletableFuture();
            REQUESTS.put(id, result);
            final StringBuilder requestBody = new StringBuilder();
            int i = 0;
            while ((i = inputStream.read()) != -1) {
                requestBody.append((char)i);
            }
            REQUEST_QUEUE.add(new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return id;
                }

                @Override
                public String getValue() {
                    return requestBody.toString();
                }

                @Override
                public String setValue(String value) {
                    return null;
                }
            });
            String output = (String)result.get();
            outputStream.write(output.getBytes());
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                Throwable ex = e.getCause();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    public static <T> T invoke(Class<T> returnType, Object input) {
        if (problem != null) {
            throw new RuntimeException(problem);
        }
        try {
            ObjectMapper mapper = LambdaClient.getObjectMapper();
            final String id = "aws-request-" + REQUEST_ID_GENERATOR.incrementAndGet();
            CompletableFuture result = new CompletableFuture();
            REQUESTS.put(id, result);
            final String requestBody = mapper.writeValueAsString(input);
            REQUEST_QUEUE.add(new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return id;
                }

                @Override
                public String getValue() {
                    return requestBody;
                }

                @Override
                public String setValue(String value) {
                    return null;
                }
            });
            String output = (String)result.get();
            return (T)mapper.readerFor(returnType).readValue(output);
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                Throwable ex = e.getCause();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    public static <T> T invokeJson(Class<T> returnType, final String json) {
        if (problem != null) {
            throw new RuntimeException(problem);
        }
        try {
            ObjectMapper mapper = LambdaClient.getObjectMapper();
            final String id = "aws-request-" + REQUEST_ID_GENERATOR.incrementAndGet();
            CompletableFuture result = new CompletableFuture();
            REQUESTS.put(id, result);
            REQUEST_QUEUE.add(new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return id;
                }

                @Override
                public String getValue() {
                    return json;
                }

                @Override
                public String setValue(String value) {
                    return null;
                }
            });
            String output = (String)result.get();
            return (T)mapper.readerFor(returnType).readValue(output);
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                Throwable ex = e.getCause();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    private static ObjectMapper getObjectMapper() {
        ArcContainer container = Arc.container();
        if (container == null) {
            return new ObjectMapper();
        }
        InstanceHandle instance = container.instance(ObjectMapper.class, new Annotation[0]);
        if (instance.isAvailable()) {
            return (ObjectMapper)instance.get();
        }
        return new ObjectMapper();
    }

    static {
        ConcurrentHashMap requests = new ConcurrentHashMap();
        LinkedBlockingDeque requestQueue = new LinkedBlockingDeque();
        ClassLoader cl = LambdaClient.class.getClassLoader();
        try {
            Class<?> root = Class.forName(LambdaClient.class.getName(), false, ClassLoader.getSystemClassLoader());
            if (root.getClassLoader() != cl) {
                requestQueue = (LinkedBlockingDeque)root.getDeclaredField("REQUEST_QUEUE").get(null);
                requests = (ConcurrentHashMap)root.getDeclaredField("REQUESTS").get(null);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        REQUESTS = requests;
        REQUEST_QUEUE = requestQueue;
    }
}

