/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.DevServicesContext;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.QuarkusTestResourceConfigurableLifecycleManager;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManagerComparator;
import io.quarkus.test.common.QuarkusTestResourceRepeatable;
import io.quarkus.test.common.ResourceArg;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.common.TestResourceScope;
import io.quarkus.test.common.TestStatus;
import io.quarkus.test.common.WithTestResource;
import io.quarkus.test.common.WithTestResourceRepeatable;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class TestResourceManager
implements Closeable {
    private static final DotName QUARKUS_TEST_RESOURCE = DotName.createSimple(QuarkusTestResource.class);
    private static final DotName WITH_TEST_RESOURCE = DotName.createSimple(WithTestResource.class);
    public static final String CLOSEABLE_NAME = TestResourceManager.class.getName() + ".closeable";
    private final List<TestResourceStartInfo> sequentialTestResources;
    private final List<TestResourceStartInfo> parallelTestResources;
    private final List<TestResourceStartInfo> allTestResources;
    private final Map<String, String> configProperties = new ConcurrentHashMap<String, String>();
    private final Set<TestResourceComparisonInfo> testResourceComparisonInfo;
    private boolean started = false;
    private TestStatus testStatus = new TestStatus(null);

    public TestResourceManager(Class<?> testClass) {
        this(testClass, null, Collections.emptyList(), false);
    }

    public TestResourceManager(Class<?> testClass, Class<?> profileClass, List<TestResourceClassEntry> additionalTestResources, boolean disableGlobalTestResources) {
        this(testClass, profileClass, additionalTestResources, disableGlobalTestResources, Collections.emptyMap(), Optional.empty());
    }

    public TestResourceManager(Class<?> testClass, Class<?> profileClass, List<TestResourceClassEntry> additionalTestResources, boolean disableGlobalTestResources, Map<String, String> devServicesProperties, Optional<String> containerNetworkId) {
        this(testClass, profileClass, additionalTestResources, disableGlobalTestResources, devServicesProperties, containerNetworkId, PathTestHelper.getTestClassesLocation(testClass));
    }

    public TestResourceManager(Class<?> testClass, Class<?> profileClass, List<TestResourceClassEntry> additionalTestResources, boolean disableGlobalTestResources, final Map<String, String> devServicesProperties, final Optional<String> containerNetworkId, Path testClassLocation) {
        this.parallelTestResources = new ArrayList<TestResourceStartInfo>();
        this.sequentialTestResources = new ArrayList<TestResourceStartInfo>();
        Set<TestResourceClassEntry> uniqueEntries = disableGlobalTestResources ? new HashSet<TestResourceClassEntry>(additionalTestResources) : this.uniqueTestResourceClassEntries(testClassLocation, testClass, profileClass, additionalTestResources);
        this.testResourceComparisonInfo = new HashSet<TestResourceComparisonInfo>();
        for (TestResourceClassEntry uniqueEntry : uniqueEntries) {
            this.testResourceComparisonInfo.add(TestResourceManager.prepareTestResourceComparisonInfo(uniqueEntry));
        }
        Set<TestResourceClassEntry> remainingUniqueEntries = this.initParallelTestResources(uniqueEntries);
        this.initSequentialTestResources(remainingUniqueEntries);
        this.allTestResources = new ArrayList<TestResourceStartInfo>(this.sequentialTestResources);
        this.allTestResources.addAll(this.parallelTestResources);
        DevServicesContext context = new DevServicesContext(){

            @Override
            public Map<String, String> devServicesProperties() {
                return devServicesProperties;
            }

            @Override
            public Optional<String> containerNetworkId() {
                return containerNetworkId;
            }
        };
        for (TestResourceStartInfo i : this.allTestResources) {
            if (!(i.getTestResource() instanceof DevServicesContext.ContextAware)) continue;
            ((DevServicesContext.ContextAware)((Object)i.getTestResource())).setIntegrationTestContext(context);
        }
    }

    public void setTestErrorCause(Throwable testErrorCause) {
        this.testStatus = new TestStatus(testErrorCause);
    }

    public void init(final String testProfileName) {
        for (TestResourceStartInfo entry : this.allTestResources) {
            try {
                QuarkusTestResourceLifecycleManager testResource = entry.getTestResource();
                testResource.setContext(new QuarkusTestResourceLifecycleManager.Context(){

                    @Override
                    public String testProfile() {
                        return testProfileName;
                    }

                    @Override
                    public TestStatus getTestStatus() {
                        return TestResourceManager.this.testStatus;
                    }
                });
                if (testResource instanceof QuarkusTestResourceConfigurableLifecycleManager && entry.getConfigAnnotation() != null) {
                    ((QuarkusTestResourceConfigurableLifecycleManager)testResource).init(entry.getConfigAnnotation());
                    continue;
                }
                testResource.init(entry.getArgs());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable initialize test resource " + entry.getTestResource(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> start() {
        this.started = true;
        ConcurrentHashMap<String, String> allProps = new ConcurrentHashMap<String, String>();
        int taskSize = this.parallelTestResources.size() + 1;
        ExecutorService executor = Executors.newFixedThreadPool(taskSize);
        ArrayList<TestResourceRunnable> tasks = new ArrayList<TestResourceRunnable>(taskSize);
        for (TestResourceStartInfo entry : this.parallelTestResources) {
            tasks.add(new TestResourceRunnable(entry, allProps));
        }
        tasks.add(new TestResourceRunnable(this.sequentialTestResources, allProps));
        try {
            CompletableFuture.allOf((CompletableFuture[])tasks.stream().map(task -> CompletableFuture.runAsync(task, executor)).toArray(CompletableFuture[]::new)).join();
        }
        finally {
            executor.shutdown();
        }
        this.configProperties.putAll(allProps);
        return allProps;
    }

    public void inject(Object testInstance) {
        for (TestResourceStartInfo entry : this.allTestResources) {
            QuarkusTestResourceLifecycleManager quarkusTestResourceLifecycleManager = entry.getTestResource();
            quarkusTestResourceLifecycleManager.inject(testInstance);
            quarkusTestResourceLifecycleManager.inject(new DefaultTestInjector(testInstance));
        }
    }

    @Override
    public void close() {
        if (!this.started) {
            return;
        }
        this.started = false;
        for (TestResourceStartInfo entry : this.allTestResources) {
            try {
                entry.getTestResource().stop();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to stop Quarkus test resource " + entry.getTestResource(), e);
            }
        }
        try {
            ((SmallRyeConfigProviderResolver)SmallRyeConfigProviderResolver.instance()).releaseConfig(Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.configProperties.clear();
    }

    public Map<String, String> getConfigProperties() {
        return this.configProperties;
    }

    private Set<TestResourceClassEntry> initParallelTestResources(Set<TestResourceClassEntry> uniqueEntries) {
        LinkedHashSet<TestResourceClassEntry> remainingUniqueEntries = new LinkedHashSet<TestResourceClassEntry>(uniqueEntries);
        for (TestResourceClassEntry entry : uniqueEntries) {
            if (!entry.isParallel()) continue;
            TestResourceStartInfo testResourceStartInfo = this.buildTestResourceEntry(entry);
            this.parallelTestResources.add(testResourceStartInfo);
            remainingUniqueEntries.remove(entry);
        }
        this.parallelTestResources.sort(new Comparator<TestResourceStartInfo>(){
            private final QuarkusTestResourceLifecycleManagerComparator lifecycleManagerComparator = new QuarkusTestResourceLifecycleManagerComparator();

            @Override
            public int compare(TestResourceStartInfo o1, TestResourceStartInfo o2) {
                return this.lifecycleManagerComparator.compare(o1.getTestResource(), o2.getTestResource());
            }
        });
        return remainingUniqueEntries;
    }

    private Set<TestResourceClassEntry> initSequentialTestResources(Set<TestResourceClassEntry> uniqueEntries) {
        TestResourceStartInfo testResourceStartInfo;
        LinkedHashSet<TestResourceClassEntry> remainingUniqueEntries = new LinkedHashSet<TestResourceClassEntry>(uniqueEntries);
        for (TestResourceClassEntry entry : uniqueEntries) {
            if (entry.isParallel()) continue;
            testResourceStartInfo = this.buildTestResourceEntry(entry);
            this.sequentialTestResources.add(testResourceStartInfo);
            remainingUniqueEntries.remove(entry);
        }
        for (QuarkusTestResourceLifecycleManager quarkusTestResourceLifecycleManager : ServiceLoader.load(QuarkusTestResourceLifecycleManager.class, Thread.currentThread().getContextClassLoader())) {
            testResourceStartInfo = new TestResourceStartInfo(quarkusTestResourceLifecycleManager);
            this.sequentialTestResources.add(testResourceStartInfo);
        }
        this.sequentialTestResources.sort(new Comparator<TestResourceStartInfo>(){
            private final QuarkusTestResourceLifecycleManagerComparator lifecycleManagerComparator = new QuarkusTestResourceLifecycleManagerComparator();

            @Override
            public int compare(TestResourceStartInfo o1, TestResourceStartInfo o2) {
                return this.lifecycleManagerComparator.compare(o1.getTestResource(), o2.getTestResource());
            }
        });
        return remainingUniqueEntries;
    }

    private TestResourceStartInfo buildTestResourceEntry(TestResourceClassEntry entry) {
        Class<? extends QuarkusTestResourceLifecycleManager> testResourceClass = entry.clazz;
        try {
            return new TestResourceStartInfo(testResourceClass.getConstructor(new Class[0]).newInstance(new Object[0]), entry.args, entry.configAnnotation);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Unable to instantiate the test resource " + testResourceClass.getName(), e);
        }
    }

    private Set<TestResourceClassEntry> uniqueTestResourceClassEntries(Path testClassLocation, Class<?> testClass, Class<?> profileClass, List<TestResourceClassEntry> additionalTestResources) {
        Class<?> profileClassFromTCCL = profileClass != null ? TestResourceManager.alwaysFromTccl(profileClass) : null;
        ProfileMetaAnnotationsUniqueEntriesConsumer profileMetaAnnotationsConsumer = null;
        if (profileClassFromTCCL != null) {
            profileMetaAnnotationsConsumer = new ProfileMetaAnnotationsUniqueEntriesConsumer(profileClassFromTCCL);
        }
        Set<TestResourceClassEntry> uniqueEntries = TestResourceManager.getUniqueTestResourceClassEntries(testClass, testClassLocation, profileMetaAnnotationsConsumer);
        uniqueEntries.addAll(additionalTestResources);
        return uniqueEntries;
    }

    public static Set<TestResourceComparisonInfo> testResourceComparisonInfo(Class<?> testClass, Path testClassLocation, List<TestResourceClassEntry> entriesFromProfile) {
        Set<TestResourceClassEntry> uniqueEntries = TestResourceManager.getUniqueTestResourceClassEntries(testClass, testClassLocation, null);
        if (uniqueEntries.isEmpty() && entriesFromProfile.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<TestResourceClassEntry> allEntries = new HashSet<TestResourceClassEntry>(uniqueEntries);
        allEntries.addAll(entriesFromProfile);
        HashSet<TestResourceComparisonInfo> result = new HashSet<TestResourceComparisonInfo>(allEntries.size());
        for (TestResourceClassEntry entry : allEntries) {
            result.add(TestResourceManager.prepareTestResourceComparisonInfo(entry));
        }
        return result;
    }

    private static TestResourceComparisonInfo prepareTestResourceComparisonInfo(TestResourceClassEntry entry) {
        Map<String, String> args;
        if (entry.configAnnotation != null) {
            args = new HashMap<String, String>(entry.args);
            args.put("configAnnotation", entry.configAnnotation.annotationType().getName());
        } else {
            args = entry.args;
        }
        return new TestResourceComparisonInfo(entry.testResourceLifecycleManagerClass().getName(), entry.getScope(), args);
    }

    private static Set<TestResourceClassEntry> getUniqueTestResourceClassEntries(Class<?> testClass, Path testClassLocation, Consumer<Set<TestResourceClassEntry>> afterMetaAnnotationAction) {
        Class<?> testClassFromTCCL = TestResourceManager.alwaysFromTccl(testClass);
        LinkedHashSet<TestResourceClassEntry> uniqueEntries = new LinkedHashSet<TestResourceClassEntry>();
        TestResourceManager.collectMetaAnnotations(testClassFromTCCL, Class::getSuperclass, uniqueEntries);
        TestResourceManager.collectMetaAnnotations(testClassFromTCCL, Class::getEnclosingClass, uniqueEntries);
        if (afterMetaAnnotationAction != null) {
            afterMetaAnnotationAction.accept(uniqueEntries);
        }
        for (AnnotationInstance annotation : TestResourceManager.findTestResourceInstancesOfClass(testClass, (IndexView)TestClassIndexer.readIndex(testClassLocation, testClass))) {
            uniqueEntries.add(TestResourceClassEntryHandler.produceEntry(annotation));
        }
        return uniqueEntries;
    }

    private static Class<?> alwaysFromTccl(Class<?> testClass) {
        if (testClass.getClassLoader().equals(Thread.currentThread().getContextClassLoader())) {
            return testClass;
        }
        try {
            return Class.forName(testClass.getName(), false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static void collectMetaAnnotations(Class<?> testClassFromTCCL, Function<Class<?>, Class<?>> next, Set<TestResourceClassEntry> uniqueEntries) {
        while (testClassFromTCCL != null && !testClassFromTCCL.getName().equals("java.lang.Object")) {
            block1: for (Annotation metaAnnotation : testClassFromTCCL.getAnnotations()) {
                for (Annotation ann : metaAnnotation.annotationType().getAnnotations()) {
                    Annotation quarkusTestResource;
                    if (ann.annotationType() == WithTestResource.class) {
                        TestResourceManager.addTestResourceEntry((WithTestResource)ann, metaAnnotation, uniqueEntries);
                        continue block1;
                    }
                    if (ann.annotationType() == WithTestResource.List.class) {
                        Arrays.stream(((WithTestResource.List)ann).value()).forEach(res -> TestResourceManager.addTestResourceEntry(res, metaAnnotation, uniqueEntries));
                        continue block1;
                    }
                    if (ann.annotationType() == WithTestResourceRepeatable.class) {
                        for (Annotation annotation : testClassFromTCCL.getAnnotationsByType(((WithTestResourceRepeatable)ann).value())) {
                            quarkusTestResource = annotation.annotationType().getAnnotation(WithTestResource.class);
                            if (quarkusTestResource == null) continue;
                            TestResourceManager.addTestResourceEntry(quarkusTestResource, annotation, uniqueEntries);
                        }
                        continue;
                    }
                    if (ann.annotationType() == QuarkusTestResource.class) {
                        TestResourceManager.addTestResourceEntry((QuarkusTestResource)ann, metaAnnotation, uniqueEntries);
                        continue block1;
                    }
                    if (ann.annotationType() == QuarkusTestResource.List.class) {
                        for (Annotation annotation : ((QuarkusTestResource.List)ann).value()) {
                            TestResourceManager.addTestResourceEntry((QuarkusTestResource)annotation, metaAnnotation, uniqueEntries);
                        }
                        continue block1;
                    }
                    if (ann.annotationType() != QuarkusTestResourceRepeatable.class) continue;
                    for (Annotation annotation : testClassFromTCCL.getAnnotationsByType(((QuarkusTestResourceRepeatable)ann).value())) {
                        quarkusTestResource = annotation.annotationType().getAnnotation(QuarkusTestResource.class);
                        if (quarkusTestResource == null) continue;
                        TestResourceManager.addTestResourceEntry((QuarkusTestResource)quarkusTestResource, annotation, uniqueEntries);
                    }
                }
            }
            testClassFromTCCL = next.apply(testClassFromTCCL);
        }
    }

    private static void addTestResourceEntry(Class<? extends QuarkusTestResourceLifecycleManager> testResourceClass, ResourceArg[] argsAnnotationValue, Annotation originalAnnotation, boolean parallel, TestResourceScope scope, Set<TestResourceClassEntry> uniqueEntries) {
        Map<String, String> args = Arrays.stream(argsAnnotationValue).collect(Collectors.toMap(ResourceArg::name, ResourceArg::value));
        uniqueEntries.add(new TestResourceClassEntry(testResourceClass, args, originalAnnotation, parallel, scope));
    }

    private static void addTestResourceEntry(WithTestResource quarkusTestResource, Annotation originalAnnotation, Set<TestResourceClassEntry> uniqueEntries) {
        TestResourceManager.addTestResourceEntry(quarkusTestResource.value(), quarkusTestResource.initArgs(), originalAnnotation, quarkusTestResource.parallel(), quarkusTestResource.scope(), uniqueEntries);
    }

    private static void addTestResourceEntry(QuarkusTestResource quarkusTestResource, Annotation originalAnnotation, Set<TestResourceClassEntry> uniqueEntries) {
        TestResourceManager.addTestResourceEntry(quarkusTestResource.value(), quarkusTestResource.initArgs(), originalAnnotation, quarkusTestResource.parallel(), quarkusTestResource.restrictToAnnotatedClass() ? TestResourceScope.RESTRICTED_TO_CLASS : TestResourceScope.GLOBAL, uniqueEntries);
    }

    private static Collection<AnnotationInstance> findTestResourceInstancesOfClass(Class<?> testClass, IndexView index) {
        Class<?> current;
        HashSet<String> currentTestClassHierarchy = new HashSet<String>();
        for (current = testClass; current != Object.class; current = current.getSuperclass()) {
            currentTestClassHierarchy.add(current.getName());
        }
        for (current = testClass.getEnclosingClass(); current != null; current = current.getEnclosingClass()) {
            currentTestClassHierarchy.add(current.getName());
        }
        LinkedHashSet<AnnotationInstance> testResourceAnnotations = new LinkedHashSet<AnnotationInstance>();
        for (DotName testResourceClasses : List.of(WITH_TEST_RESOURCE, QUARKUS_TEST_RESOURCE)) {
            for (AnnotationInstance annotation : index.getAnnotations(testResourceClasses)) {
                if (!TestResourceManager.keepTestResourceAnnotation(annotation, annotation.target().asClass(), currentTestClassHierarchy)) continue;
                testResourceAnnotations.add(annotation);
            }
        }
        for (DotName testResourceListClasses : List.of(DotName.createSimple((String)WithTestResource.List.class.getName()), DotName.createSimple((String)QuarkusTestResource.List.class.getName()))) {
            for (AnnotationInstance annotation : index.getAnnotations(testResourceListClasses)) {
                for (AnnotationInstance nestedAnnotation : annotation.value().asNestedArray()) {
                    if (!TestResourceManager.keepTestResourceAnnotation(nestedAnnotation, annotation.target().asClass(), currentTestClassHierarchy)) continue;
                    testResourceAnnotations.add(nestedAnnotation);
                }
            }
        }
        return testResourceAnnotations;
    }

    private static boolean keepTestResourceAnnotation(AnnotationInstance annotation, ClassInfo targetClass, Set<String> currentTestClassHierarchy) {
        if (targetClass.isAnnotation()) {
            return false;
        }
        if (TestResourceManager.restrictToAnnotatedClass(annotation)) {
            return currentTestClassHierarchy.contains(targetClass.name().toString('.'));
        }
        return true;
    }

    private static boolean restrictToAnnotatedClass(AnnotationInstance annotation) {
        return TestResourceClassEntryHandler.determineScope(annotation) == TestResourceScope.RESTRICTED_TO_CLASS || TestResourceClassEntryHandler.determineScope(annotation) == TestResourceScope.MATCHING_RESOURCES;
    }

    public Set<TestResourceComparisonInfo> testResourceComparisonInfo() {
        return this.testResourceComparisonInfo;
    }

    public static boolean testResourcesRequireReload(Set<TestResourceComparisonInfo> existing, Set<TestResourceComparisonInfo> next) {
        if (existing.isEmpty() && next.isEmpty()) {
            return false;
        }
        if (TestResourceManager.anyResourceRestrictedToClass(existing) || TestResourceManager.anyResourceRestrictedToClass(next)) {
            return true;
        }
        HashSet<TestResourceComparisonInfo> inExistingAndNotNext = new HashSet<TestResourceComparisonInfo>(existing);
        inExistingAndNotNext.removeAll(next);
        if (!inExistingAndNotNext.isEmpty()) {
            return true;
        }
        HashSet<TestResourceComparisonInfo> inNextAndNotExisting = new HashSet<TestResourceComparisonInfo>(next);
        inNextAndNotExisting.removeAll(existing);
        return !inNextAndNotExisting.isEmpty();
    }

    private static boolean anyResourceRestrictedToClass(Set<TestResourceComparisonInfo> testResources) {
        for (TestResourceComparisonInfo info : testResources) {
            if (info.scope != TestResourceScope.RESTRICTED_TO_CLASS) continue;
            return true;
        }
        return false;
    }

    public static class TestResourceClassEntry {
        private final Class<? extends QuarkusTestResourceLifecycleManager> clazz;
        private final Map<String, String> args;
        private final boolean parallel;
        private final Annotation configAnnotation;
        private final TestResourceScope scope;

        public TestResourceClassEntry(Class<? extends QuarkusTestResourceLifecycleManager> clazz, Map<String, String> args, Annotation configAnnotation, boolean parallel, TestResourceScope scope) {
            this.clazz = clazz;
            this.args = args;
            this.configAnnotation = configAnnotation;
            this.parallel = parallel;
            this.scope = scope;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TestResourceClassEntry entry = (TestResourceClassEntry)object;
            return this.parallel == entry.parallel && Objects.equals(this.clazz, entry.clazz) && Objects.equals(this.args, entry.args) && Objects.equals(this.configAnnotation, entry.configAnnotation) && this.scope == entry.scope;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.clazz, this.args, this.parallel, this.configAnnotation, this.scope});
        }

        public boolean isParallel() {
            return this.parallel;
        }

        public Class<? extends QuarkusTestResourceLifecycleManager> testResourceLifecycleManagerClass() {
            return this.clazz;
        }

        public TestResourceScope getScope() {
            return this.scope;
        }
    }

    public record TestResourceComparisonInfo(String testResourceLifecycleManagerClass, TestResourceScope scope, Map<String, String> args) {
    }

    private static class TestResourceStartInfo {
        private final QuarkusTestResourceLifecycleManager testResource;
        private final Map<String, String> args;
        private final Annotation configAnnotation;

        public TestResourceStartInfo(QuarkusTestResourceLifecycleManager testResource) {
            this(testResource, Collections.emptyMap(), null);
        }

        public TestResourceStartInfo(QuarkusTestResourceLifecycleManager testResource, Map<String, String> args, Annotation configAnnotation) {
            this.testResource = testResource;
            this.args = args;
            this.configAnnotation = configAnnotation;
        }

        public QuarkusTestResourceLifecycleManager getTestResource() {
            return this.testResource;
        }

        public Map<String, String> getArgs() {
            return this.args;
        }

        public Annotation getConfigAnnotation() {
            return this.configAnnotation;
        }
    }

    private static class TestResourceRunnable
    implements Runnable {
        private final List<TestResourceStartInfo> entries;
        private final Map<String, String> allProps;

        public TestResourceRunnable(TestResourceStartInfo entry, Map<String, String> allProps) {
            this(Collections.singletonList(entry), allProps);
        }

        public TestResourceRunnable(List<TestResourceStartInfo> entries, Map<String, String> allProps) {
            this.entries = entries;
            this.allProps = allProps;
        }

        @Override
        public void run() {
            for (TestResourceStartInfo entry : this.entries) {
                try {
                    Map<String, String> start = entry.getTestResource().start();
                    if (start == null) continue;
                    this.allProps.putAll(start);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to start Quarkus test resource " + entry.getTestResource().getClass().toString(), e);
                }
            }
        }
    }

    static class DefaultTestInjector
    implements QuarkusTestResourceLifecycleManager.TestInjector {
        final Object testInstance;

        private DefaultTestInjector(Object testInstance) {
            this.testInstance = testInstance;
        }

        @Override
        public void injectIntoFields(Object fieldValue, Predicate<Field> predicate) {
            for (Class<?> c = this.testInstance.getClass(); c != Object.class; c = c.getSuperclass()) {
                for (Field f : c.getDeclaredFields()) {
                    if (!predicate.test(f)) continue;
                    f.setAccessible(true);
                    try {
                        f.set(this.testInstance, fieldValue);
                        return;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to set field '" + f.getName() + "' using 'QuarkusTestResourceLifecycleManager.TestInjector' ", e);
                    }
                }
            }
        }
    }

    private static class ProfileMetaAnnotationsUniqueEntriesConsumer
    implements Consumer<Set<TestResourceClassEntry>> {
        private final Class<?> profileClassFromTCCL;

        public ProfileMetaAnnotationsUniqueEntriesConsumer(Class<?> profileClassFromTCCL) {
            this.profileClassFromTCCL = profileClassFromTCCL;
        }

        @Override
        public void accept(Set<TestResourceClassEntry> entries) {
            TestResourceManager.collectMetaAnnotations(this.profileClassFromTCCL, Class::getSuperclass, entries);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface TestResourceClassEntryHandler {
        public static final List<TestResourceClassEntryHandler> HANDLERS = List.of(new QuarkusTestResourceTestResourceClassEntryHandler(), new WithTestResourceTestResourceClassEntryHandler());

        public static TestResourceScope determineScope(AnnotationInstance annotation) {
            for (TestResourceClassEntryHandler handler : HANDLERS) {
                if (!handler.appliesTo(annotation)) continue;
                return handler.scope(annotation);
            }
            throw new IllegalStateException("Annotation '" + annotation.name() + "' is not supported");
        }

        public static TestResourceClassEntry produceEntry(AnnotationInstance annotation) {
            for (TestResourceClassEntryHandler producer : HANDLERS) {
                if (!producer.appliesTo(annotation)) continue;
                return producer.produce(annotation);
            }
            throw new IllegalStateException("Annotation '" + annotation.name() + "' is not supported");
        }

        public boolean appliesTo(AnnotationInstance var1);

        public TestResourceScope scope(AnnotationInstance var1);

        public TestResourceClassEntry produce(AnnotationInstance var1);
    }

    private static final class WithTestResourceTestResourceClassEntryHandler
    extends AbstractTestResourceClassEntryHandler
    implements TestResourceClassEntryHandler {
        private WithTestResourceTestResourceClassEntryHandler() {
        }

        @Override
        public boolean appliesTo(AnnotationInstance annotation) {
            return WITH_TEST_RESOURCE.equals((Object)annotation.name());
        }

        @Override
        public TestResourceClassEntry produce(AnnotationInstance annotation) {
            return new TestResourceClassEntry(this.lifecycleManager(annotation), this.args(annotation), null, this.isParallel(annotation), this.scope(annotation));
        }

        @Override
        public TestResourceScope scope(AnnotationInstance annotation) {
            TestResourceScope scope = TestResourceScope.MATCHING_RESOURCES;
            AnnotationValue restrict = annotation.value("scope");
            if (restrict != null) {
                scope = TestResourceScope.valueOf(restrict.asEnum());
            }
            return scope;
        }
    }

    private static final class QuarkusTestResourceTestResourceClassEntryHandler
    extends AbstractTestResourceClassEntryHandler
    implements TestResourceClassEntryHandler {
        private QuarkusTestResourceTestResourceClassEntryHandler() {
        }

        @Override
        public boolean appliesTo(AnnotationInstance annotation) {
            return QUARKUS_TEST_RESOURCE.equals((Object)annotation.name());
        }

        @Override
        public TestResourceClassEntry produce(AnnotationInstance annotation) {
            return new TestResourceClassEntry(this.lifecycleManager(annotation), this.args(annotation), null, this.isParallel(annotation), this.scope(annotation));
        }

        @Override
        public TestResourceScope scope(AnnotationInstance annotation) {
            TestResourceScope scope = TestResourceScope.GLOBAL;
            AnnotationValue restrict = annotation.value("restrictToAnnotatedClass");
            if (restrict != null && restrict.asBoolean()) {
                scope = TestResourceScope.RESTRICTED_TO_CLASS;
            }
            return scope;
        }
    }

    private static abstract class AbstractTestResourceClassEntryHandler {
        private AbstractTestResourceClassEntryHandler() {
        }

        Class<? extends QuarkusTestResourceLifecycleManager> lifecycleManager(AnnotationInstance annotation) {
            return this.loadTestResourceClassFromTCCL(annotation.value().asString());
        }

        Class<? extends QuarkusTestResourceLifecycleManager> loadTestResourceClassFromTCCL(String className) {
            try {
                return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        Map<String, String> args(AnnotationInstance annotation) {
            AnnotationInstance[] resourceArgsInstances;
            AnnotationValue argsAnnotationValue = annotation.value("initArgs");
            if (argsAnnotationValue == null) {
                return Collections.emptyMap();
            }
            HashMap<String, String> args = new HashMap<String, String>();
            for (AnnotationInstance resourceArgsInstance : resourceArgsInstances = argsAnnotationValue.asNestedArray()) {
                args.put(resourceArgsInstance.value("name").asString(), resourceArgsInstance.value().asString());
            }
            return args;
        }

        boolean isParallel(AnnotationInstance annotation) {
            AnnotationValue parallelAnnotationValue = annotation.value("parallel");
            if (parallelAnnotationValue != null) {
                return parallelAnnotationValue.asBoolean();
            }
            return false;
        }
    }
}

