/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.deployment.cmd.RunCommandActionResultBuildItem;
import io.quarkus.deployment.cmd.RunCommandHandler;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.input.TeeInputStream;

public class RunCommandLauncher
implements ArtifactLauncher<ArtifactLauncher.InitContext> {
    Process quarkusProcess = null;
    private List<String> args;
    private long waitTimeSeconds;
    private Path workingDir;
    private String startedExpression;
    private boolean needsLogFile;
    private Path logFilePath;
    private final Map<String, String> systemProps = new HashMap<String, String>();
    private ExecutorService executorService = Executors.newFixedThreadPool(3);

    public static RunCommandLauncher tryLauncher(QuarkusBootstrap bootstrap, String target, Duration waitTime) {
        final HashMap cmds = new HashMap();
        try (CuratedApplication curatedApplication = bootstrap.bootstrap();){
            AugmentAction action = curatedApplication.createAugmentor();
            action.performCustomBuild(RunCommandHandler.class.getName(), (Object)new Consumer<Map<String, List>>(){

                @Override
                public void accept(Map<String, List> accepted) {
                    cmds.putAll(accepted);
                }
            }, new String[]{RunCommandActionResultBuildItem.class.getName()});
        }
        catch (BootstrapException ex) {
            throw new RuntimeException(ex);
        }
        List cmd = null;
        if (target != null) {
            cmd = (List)cmds.get(target);
            if (cmd == null) {
                throw new RuntimeException("quarkus.run.target \"" + target + "\" does not exist");
            }
        } else {
            if (cmds.size() == 1) {
                return null;
            }
            if (cmds.size() == 2) {
                for (Map.Entry entry : cmds.entrySet()) {
                    if (((String)entry.getKey()).equals("java")) continue;
                    cmd = (List)entry.getValue();
                    break;
                }
            } else {
                if (cmds.size() > 2) {
                    String tooMany = cmds.keySet().stream().collect(Collectors.joining(" "));
                    throw new RuntimeException("Too many extensions support quarkus:run.  Set quarkus.run.target to pick one to run during integration tests: " + tooMany);
                }
                throw new RuntimeException("Should never reach this!");
            }
        }
        RunCommandLauncher launcher = new RunCommandLauncher();
        launcher.args = (List)cmd.get(0);
        launcher.workingDir = (Path)cmd.get(1);
        launcher.startedExpression = (String)cmd.get(2);
        launcher.needsLogFile = (Boolean)cmd.get(3);
        launcher.logFilePath = (Path)cmd.get(4);
        launcher.waitTimeSeconds = waitTime.getSeconds();
        return launcher;
    }

    @Override
    public void init(ArtifactLauncher.InitContext initContext) {
        throw new UnsupportedOperationException("not implemented for run command yet");
    }

    @Override
    public ArtifactLauncher.LaunchResult runToCompletion(String[] args) {
        throw new UnsupportedOperationException("not implemented for run command yet");
    }

    @Override
    public void start() throws IOException {
        System.setProperty("test.url", TestHTTPResourceManager.getUri());
        Path logFile = this.logFilePath;
        System.out.println("Executing \"" + String.join((CharSequence)" ", this.args) + "\"");
        if (this.needsLogFile) {
            if (this.logFilePath == null) {
                logFile = PropertyTestUtil.getLogFilePath();
            }
            System.out.println("Creating Logfile for custom extension run: " + logFile.toString());
            Files.deleteIfExists(logFile);
            Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
            FileOutputStream logOutputStream = new FileOutputStream(logFile.toFile(), true);
            this.quarkusProcess = new ProcessBuilder(this.args).directory(this.workingDir.toFile()).redirectError(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).start();
            TeeInputStream teo = new TeeInputStream(this.quarkusProcess.getInputStream(), (OutputStream)System.out);
            this.executorService.submit(() -> RunCommandLauncher.lambda$start$0((InputStream)teo, logOutputStream));
            TeeInputStream tee = new TeeInputStream(this.quarkusProcess.getErrorStream(), (OutputStream)System.err);
            this.executorService.submit(() -> RunCommandLauncher.lambda$start$1((InputStream)tee, logOutputStream));
        } else {
            this.quarkusProcess = new ProcessBuilder(this.args).directory(this.workingDir.toFile()).inheritIO().start();
        }
        CountDownLatch signal = new CountDownLatch(1);
        WaitForStartReader reader = new WaitForStartReader(logFile, Duration.ofSeconds(this.waitTimeSeconds), signal, this.startedExpression);
        this.executorService.submit(reader);
        try {
            signal.await(this.waitTimeSeconds + 2L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!reader.isStarted()) {
            LauncherUtil.destroyProcess(this.quarkusProcess, true);
            throw new RuntimeException("Unable to start target quarkus application " + this.waitTimeSeconds + "s");
        }
    }

    @Override
    public boolean listensOnSsl() {
        return false;
    }

    @Override
    public void includeAsSysProps(Map<String, String> systemProps) {
        this.systemProps.putAll(systemProps);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
        if (this.quarkusProcess != null) {
            LauncherUtil.destroyProcess(this.quarkusProcess, true);
        }
    }

    private static /* synthetic */ Long lambda$start$1(InputStream tee, FileOutputStream logOutputStream) throws Exception {
        return tee.transferTo(logOutputStream);
    }

    private static /* synthetic */ Long lambda$start$0(InputStream teo, FileOutputStream logOutputStream) throws Exception {
        return teo.transferTo(logOutputStream);
    }

    private static class WaitForStartReader
    implements Runnable {
        private final Path processOutput;
        private final Duration waitTime;
        private final CountDownLatch signal;
        private final Pattern startedRegex;
        private volatile boolean started;

        public WaitForStartReader(Path processOutput, Duration waitTime, CountDownLatch signal, String startedExpression) {
            this.processOutput = processOutput;
            this.waitTime = waitTime;
            this.signal = signal;
            this.startedRegex = Pattern.compile(startedExpression);
        }

        public boolean isStarted() {
            return this.started;
        }

        @Override
        public void run() {
            long bailoutTime = System.currentTimeMillis() + this.waitTime.toMillis();
            try (BufferedReader reader = new BufferedReader(new FileReader(this.processOutput.toFile()));){
                while (true) {
                    if (reader.ready()) {
                        String line = reader.readLine();
                        if (!this.startedRegex.matcher(line).find()) continue;
                        this.started = true;
                        this.signal.countDown();
                        return;
                    }
                    long now = System.currentTimeMillis();
                    if (now > bailoutTime) {
                        this.signal.countDown();
                        return;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        this.signal.countDown();
                        reader.close();
                        return;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Exception occurred while reading process output from file " + String.valueOf(this.processOutput));
                e.printStackTrace();
                this.signal.countDown();
                return;
            }
        }
    }
}

