/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.ArtifactInfoUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractDevUIBuildItem
extends MultiBuildItem {
    private final Class<?> callerClass;
    private String extensionIdentifier = null;
    private static final String DOT = ".";
    private final String customIdentifier;
    public static final String DEV_UI = "devui";

    public AbstractDevUIBuildItem() {
        this(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractDevUIBuildItem(String customIdentifier) {
        this.customIdentifier = customIdentifier;
        if (this.customIdentifier == null) {
            StackWalker stackWalker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
            List stackFrames = stackWalker.walk(frames -> frames.collect(Collectors.toList()));
            Optional stackFrame = stackWalker.walk(frames -> frames.filter(frame -> !frame.getDeclaringClass().getPackageName().startsWith("io.quarkus.devui.spi") && !frame.getDeclaringClass().getPackageName().startsWith("io.quarkus.devui.deployment")).findFirst());
            if (!stackFrame.isPresent()) throw new RuntimeException("Could not detect extension identifier automatically");
            this.callerClass = ((StackWalker.StackFrame)stackFrame.get()).getDeclaringClass();
            return;
        } else {
            this.callerClass = null;
        }
    }

    public String getExtensionPathName(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (this.customIdentifier != null) {
            return this.customIdentifier;
        }
        if (this.callerClass == null) {
            return DEV_UI;
        }
        if (this.extensionIdentifier == null) {
            Map.Entry groupIdAndArtifactId = ArtifactInfoUtil.groupIdAndArtifactId(this.callerClass, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
            this.extensionIdentifier = (String)groupIdAndArtifactId.getKey() + DOT + (String)groupIdAndArtifactId.getValue();
        }
        return this.extensionIdentifier;
    }

    public boolean isInternal() {
        return this.customIdentifier != null;
    }
}

