/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EngineImpl;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.MultiResultNode;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SectionInitContextImpl;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

class SectionNode
implements TemplateNode {
    final String name;
    final List<SectionBlock> blocks;
    private final SectionHelper helper;
    private final TemplateNode.Origin origin;

    static Builder builder(String helperName, TemplateNode.Origin origin) {
        return new Builder(helperName, origin);
    }

    SectionNode(String name, List<SectionBlock> blocks, SectionHelper helper, TemplateNode.Origin origin) {
        this.name = name;
        this.blocks = ImmutableList.copyOf(blocks);
        this.helper = helper;
        this.origin = origin;
    }

    @Override
    public CompletionStage<ResultNode> resolve(ResolutionContext context) {
        return this.helper.resolve(new SectionResolutionContextImpl(context));
    }

    @Override
    public TemplateNode.Origin getOrigin() {
        return this.origin;
    }

    void optimizeNodes(Set<TemplateNode> nodes) {
        for (SectionBlock block : this.blocks) {
            block.optimizeNodes(nodes);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SectionNode [helper=").append(this.helper.getClass().getSimpleName()).append(", origin= ").append(this.origin).append("]");
        return builder.toString();
    }

    @Override
    public List<Expression> getExpressions() {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (SectionBlock block : this.blocks) {
            expressions.addAll(block.getExpressions());
        }
        return expressions;
    }

    class SectionResolutionContextImpl
    implements SectionHelper.SectionResolutionContext {
        private final ResolutionContext resolutionContext;

        public SectionResolutionContextImpl(ResolutionContext resolutionContext) {
            this.resolutionContext = resolutionContext;
        }

        @Override
        public CompletionStage<ResultNode> execute(SectionBlock block, ResolutionContext context) {
            int size;
            if (block == null) {
                block = SectionNode.this.blocks.get(0);
            }
            if ((size = block.nodes.size()) == 1) {
                return block.nodes.get(0).resolve(context);
            }
            CompletableFuture<ResultNode> result = new CompletableFuture<ResultNode>();
            CompletableFuture[] allResults = new CompletableFuture[size];
            LinkedList<CompletableFuture<ResultNode>> asyncResults = new LinkedList<CompletableFuture<ResultNode>>();
            int idx = 0;
            for (TemplateNode node : block.nodes) {
                CompletableFuture<ResultNode> nodeResult = node.resolve(context).toCompletableFuture();
                allResults[idx++] = nodeResult;
                if (node.isConstant()) continue;
                asyncResults.add(nodeResult);
            }
            if (asyncResults.isEmpty()) {
                result.complete(new MultiResultNode(allResults));
            } else {
                CompletableFuture<Void> cs = asyncResults.size() == 1 ? (CompletableFuture<Void>)asyncResults.get(0) : CompletableFuture.allOf(asyncResults.toArray(new CompletableFuture[0]));
                cs.whenComplete((v, t) -> {
                    if (t != null) {
                        result.completeExceptionally((Throwable)t);
                    } else {
                        result.complete(new MultiResultNode(allResults));
                    }
                });
            }
            return result;
        }

        @Override
        public ResolutionContext resolutionContext() {
            return this.resolutionContext;
        }
    }

    static class Builder {
        final String helperName;
        final TemplateNode.Origin origin;
        private final List<SectionBlock> blocks;
        SectionHelperFactory<?> factory;
        private EngineImpl engine;

        public Builder(String helperName, TemplateNode.Origin origin) {
            this.helperName = helperName;
            this.origin = origin;
            this.blocks = new ArrayList<SectionBlock>();
        }

        Builder addBlock(SectionBlock block) {
            this.blocks.add(block);
            return this;
        }

        Builder setHelperFactory(SectionHelperFactory<?> factory) {
            this.factory = factory;
            return this;
        }

        Builder setEngine(EngineImpl engine) {
            this.engine = engine;
            return this;
        }

        SectionNode build() {
            return new SectionNode(this.helperName, this.blocks, (SectionHelper)this.factory.initialize(new SectionInitContextImpl(this.engine, this.blocks, this::createParserError)), this.origin);
        }

        TemplateException createParserError(String message) {
            StringBuilder builder = new StringBuilder("Parser error");
            if (!this.origin.getTemplateId().equals(this.origin.getTemplateGeneratedId())) {
                builder.append(" in template [").append(this.origin.getTemplateId()).append("]");
            }
            builder.append(" on line ").append(this.origin.getLine()).append(": ").append(message);
            return new TemplateException(this.origin, builder.toString());
        }
    }
}

