/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Booleans;
import io.quarkus.qute.ErrorCode;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.LiteralSupport;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class FragmentSectionHelper
implements SectionHelper {
    private static final String ID = "id";
    private final String identifier;
    private final Expression rendered;

    FragmentSectionHelper(String identifier, Expression isVisible) {
        this.identifier = identifier;
        this.rendered = isVisible;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        if (this.rendered == null || context.getParameters().containsKey("qute$fragment") || context.resolutionContext().getAttribute("qute$fragment") != null) {
            return context.execute();
        }
        return context.resolutionContext().evaluate(this.rendered).thenCompose(r -> Booleans.isFalsy(r) ? ResultNode.NOOP : context.execute());
    }

    static enum Code implements ErrorCode
    {
        INVALID_FRAGMENT_ID,
        NON_UNIQUE_FRAGMENT_ID;


        @Override
        public String getName() {
            return "FRAGMENT_" + this.name();
        }
    }

    public static class Factory
    implements SectionHelperFactory<FragmentSectionHelper> {
        static final Pattern FRAGMENT_PATTERN = Pattern.compile("[a-zA-Z0-9_]+");
        static final String RENDERED = "rendered";
        private final Map<String, Map<String, TemplateNode.Origin>> templateToFragments = new ConcurrentHashMap<String, Map<String, TemplateNode.Origin>>();

        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of("fragment");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(FragmentSectionHelper.ID).addParameter(Parameter.builder(RENDERED).ignoreUnnamedValues().optional().build()).build();
        }

        @Override
        public FragmentSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            String id = context.getParameter(FragmentSectionHelper.ID);
            if (LiteralSupport.isStringLiteralSeparator(id.charAt(0))) {
                id = id.substring(1, id.length() - 1);
            }
            if (!FRAGMENT_PATTERN.matcher(id).matches()) {
                throw context.error("found an invalid fragment identifier [{id}] - an identifier can only consist of alphanumeric characters and underscores").code(Code.INVALID_FRAGMENT_ID).argument(FragmentSectionHelper.ID, id).origin(context.getOrigin()).build();
            }
            String generatedId = context.getOrigin().getTemplateGeneratedId();
            Map<String, TemplateNode.Origin> fragments = this.templateToFragments.get(generatedId);
            if (fragments == null) {
                fragments = new HashMap<String, TemplateNode.Origin>();
                fragments.put(id, context.getOrigin());
                this.templateToFragments.put(generatedId, fragments);
            } else {
                TemplateNode.Origin existing = fragments.put(id, context.getOrigin());
                if (existing != null) {
                    throw context.error("found a non-unique fragment identifier: [{id}]").code(Code.NON_UNIQUE_FRAGMENT_ID).argument(FragmentSectionHelper.ID, id).origin(context.getOrigin()).build();
                }
            }
            return new FragmentSectionHelper(id, context.getExpression(RENDERED));
        }

        @Override
        public Scope initializeBlock(Scope previousScope, SectionHelperFactory.BlockInfo block) {
            String visible;
            if (block.getLabel().equals("$main") && (visible = block.getParameter(RENDERED)) != null) {
                block.addExpression(RENDERED, visible);
            }
            return previousScope;
        }
    }
}

