/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;

public class CacheSectionHelper
implements SectionHelper {
    private final String keyPrefix;
    private final Expression key;
    private final Cache cache;

    CacheSectionHelper(String keyPrefix, Expression key, Cache cache) {
        this.keyPrefix = keyPrefix;
        this.key = key;
        this.cache = cache;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        if (this.key == null) {
            return this.resolveInternal(this.keyPrefix, context);
        }
        return context.resolutionContext().evaluate(this.key).thenCompose(key -> this.resolveInternal(this.keyPrefix + key.toString(), context));
    }

    private CompletionStage<ResultNode> resolveInternal(String key, final SectionHelper.SectionResolutionContext context) {
        return this.cache.getValue(key, new Function<String, CompletionStage<ResultNode>>(){

            @Override
            public CompletionStage<ResultNode> apply(String key) {
                return context.execute().thenCompose(rn -> {
                    StringBuilder sb = new StringBuilder();
                    rn.process(sb::append);
                    final String result = sb.toString();
                    return CompletedStage.of(new ResultNode(){

                        @Override
                        public void process(Consumer<String> resultConsumer) {
                            resultConsumer.accept(result);
                        }
                    });
                });
            }
        });
    }

    public static interface Cache {
        public CompletionStage<ResultNode> getValue(String var1, Function<String, CompletionStage<ResultNode>> var2);
    }

    public static class Factory
    implements SectionHelperFactory<CacheSectionHelper> {
        static final String KEY = "key";
        static final String DEFAULT_KEY = "$default$";
        private final Cache cache;

        public Factory(Cache cache) {
            this.cache = cache;
        }

        @Override
        public List<String> getDefaultAliases() {
            return List.of("cached");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(KEY, DEFAULT_KEY).build();
        }

        @Override
        public CacheSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            StringBuilder keyPrefix = new StringBuilder().append(context.getOrigin().getTemplateId()).append(":").append(context.getOrigin().getLine()).append(":").append(context.getOrigin().getLineCharacterStart()).append("_");
            Expression key = null;
            if (!context.getParameter(KEY).equals(DEFAULT_KEY)) {
                key = context.getExpression(KEY);
            }
            return new CacheSectionHelper(keyPrefix.toString(), key, this.cache);
        }

        @Override
        public Scope initializeBlock(Scope previousScope, SectionHelperFactory.BlockInfo block) {
            if (block.getLabel().equals("$main")) {
                String key = block.getParameters().get(KEY);
                if (!key.equals(DEFAULT_KEY)) {
                    block.addExpression(KEY, key);
                }
                return previousScope;
            }
            return previousScope;
        }
    }
}

