/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl.multipart;

import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import io.netty.handler.codec.http.multipart.MixedAttribute;
import io.vertx.core.http.HttpClientResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QuarkusMultipartResponseDataFactory {
    public static final long MINSIZE = 16384L;
    public static final long MAXSIZE = -1L;
    private final boolean useDisk;
    private final boolean checkSize;
    private long minSize;
    private long maxSize = -1L;
    private Charset charset = HttpConstants.DEFAULT_CHARSET;
    private String baseDir;
    private boolean deleteOnExit;
    private final Map<HttpClientResponse, List<HttpData>> responseFileDeleteMap = Collections.synchronizedMap(new IdentityHashMap());

    public QuarkusMultipartResponseDataFactory() {
        this.useDisk = false;
        this.checkSize = true;
        this.minSize = 16384L;
    }

    public QuarkusMultipartResponseDataFactory(Charset charset) {
        this();
        this.charset = charset;
    }

    public QuarkusMultipartResponseDataFactory(boolean useDisk) {
        this.useDisk = useDisk;
        this.checkSize = false;
    }

    public QuarkusMultipartResponseDataFactory(boolean useDisk, Charset charset) {
        this(useDisk);
        this.charset = charset;
    }

    public QuarkusMultipartResponseDataFactory(long minSize) {
        this.useDisk = false;
        this.checkSize = true;
        this.minSize = minSize;
    }

    public QuarkusMultipartResponseDataFactory(long minSize, Charset charset) {
        this(minSize);
        this.charset = charset;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    public void setMaxLimit(long maxSize) {
        this.maxSize = maxSize;
    }

    private List<HttpData> getList(HttpClientResponse response) {
        List<HttpData> list = this.responseFileDeleteMap.get(response);
        if (list == null) {
            list = new ArrayList<HttpData>();
            this.responseFileDeleteMap.put(response, list);
        }
        return list;
    }

    public Attribute createAttribute(HttpClientResponse response, String name) {
        if (this.useDisk) {
            DiskAttribute attribute = new DiskAttribute(name, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            List<HttpData> list = this.getList(response);
            list.add((HttpData)attribute);
            return attribute;
        }
        if (this.checkSize) {
            MixedAttribute attribute = new MixedAttribute(name, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            List<HttpData> list = this.getList(response);
            list.add((HttpData)attribute);
            return attribute;
        }
        MemoryAttribute attribute = new MemoryAttribute(name);
        attribute.setMaxSize(this.maxSize);
        return attribute;
    }

    public Attribute createAttribute(HttpClientResponse response, String name, long definedSize) {
        if (this.useDisk) {
            DiskAttribute attribute = new DiskAttribute(name, definedSize, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            List<HttpData> list = this.getList(response);
            list.add((HttpData)attribute);
            return attribute;
        }
        if (this.checkSize) {
            MixedAttribute attribute = new MixedAttribute(name, definedSize, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            List<HttpData> list = this.getList(response);
            list.add((HttpData)attribute);
            return attribute;
        }
        MemoryAttribute attribute = new MemoryAttribute(name, definedSize);
        attribute.setMaxSize(this.maxSize);
        return attribute;
    }

    private static void checkHttpDataSize(HttpData data) {
        try {
            data.checkSize(data.length());
        }
        catch (IOException ignored) {
            throw new IllegalArgumentException("Attribute bigger than maxSize allowed");
        }
    }

    public Attribute createAttribute(HttpClientResponse response, String name, String value) {
        if (this.useDisk) {
            DiskAttribute attribute;
            try {
                attribute = new DiskAttribute(name, value, this.charset, this.baseDir, this.deleteOnExit);
                attribute.setMaxSize(this.maxSize);
            }
            catch (IOException e) {
                attribute = new MixedAttribute(name, value, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
                attribute.setMaxSize(this.maxSize);
            }
            QuarkusMultipartResponseDataFactory.checkHttpDataSize((HttpData)attribute);
            List<HttpData> list = this.getList(response);
            list.add((HttpData)attribute);
            return attribute;
        }
        if (this.checkSize) {
            MixedAttribute attribute = new MixedAttribute(name, value, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            QuarkusMultipartResponseDataFactory.checkHttpDataSize((HttpData)attribute);
            List<HttpData> list = this.getList(response);
            list.add((HttpData)attribute);
            return attribute;
        }
        try {
            MemoryAttribute attribute = new MemoryAttribute(name, value, this.charset);
            attribute.setMaxSize(this.maxSize);
            QuarkusMultipartResponseDataFactory.checkHttpDataSize((HttpData)attribute);
            return attribute;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public FileUpload createFileUpload(HttpClientResponse response, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        DiskFileUpload fileUpload = new DiskFileUpload(name, filename, contentType, contentTransferEncoding, charset, size, this.baseDir, this.deleteOnExit);
        fileUpload.setMaxSize(this.maxSize);
        QuarkusMultipartResponseDataFactory.checkHttpDataSize((HttpData)fileUpload);
        List<HttpData> list = this.getList(response);
        list.add((HttpData)fileUpload);
        return fileUpload;
    }

    public void removeHttpDataFromClean(HttpClientResponse response, InterfaceHttpData data) {
        if (!(data instanceof HttpData)) {
            return;
        }
        List<HttpData> list = this.responseFileDeleteMap.get(response);
        if (list == null) {
            return;
        }
        Iterator<HttpData> i = list.iterator();
        while (i.hasNext()) {
            HttpData n = i.next();
            if (n != data) continue;
            i.remove();
            if (list.isEmpty()) {
                this.responseFileDeleteMap.remove(response);
            }
            return;
        }
    }

    public void cleanResponseHttpData(HttpClientResponse response) {
        List<HttpData> list = this.responseFileDeleteMap.remove(response);
        if (list != null) {
            for (HttpData data : list) {
                data.release();
            }
        }
    }

    public void cleanAllHttpData() {
        Iterator<Map.Entry<HttpClientResponse, List<HttpData>>> i = this.responseFileDeleteMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<HttpClientResponse, List<HttpData>> e = i.next();
            List<HttpData> list = e.getValue();
            for (HttpData data : list) {
                data.release();
            }
            i.remove();
        }
    }

    public void cleanResponseHttpDatas(HttpClientResponse response) {
        this.cleanResponseHttpData(response);
    }

    public void cleanAllHttpDatas() {
        this.cleanAllHttpData();
    }
}

