/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.core.BlockingOperationSupport;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class BlockingHandler
implements ServerRestHandler {
    private volatile Executor executor;
    private final Supplier<Executor> supplier;

    public BlockingHandler(Supplier<Executor> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        if (BlockingOperationSupport.isBlockingAllowed()) {
            return;
        }
        if (this.executor == null) {
            this.executor = this.supplier.get();
        }
        requestContext.suspend();
        requestContext.resume(this.executor);
    }
}

