/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.AbstractCodec;
import io.r2dbc.h2.util.Assert;
import java.math.BigDecimal;
import org.h2.value.Value;
import org.h2.value.ValueDecimal;

final class BigDecimalCodec
extends AbstractCodec<BigDecimal> {
    BigDecimalCodec() {
        super(BigDecimal.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 6;
    }

    @Override
    BigDecimal doDecode(Value value, Class<? extends BigDecimal> type) {
        return value.getBigDecimal();
    }

    @Override
    Value doEncode(BigDecimal value) {
        return ValueDecimal.get((BigDecimal)Assert.requireNonNull(value, "value must not be null"));
    }
}

