/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.client.Client;
import io.r2dbc.h2.codecs.AbstractCodec;
import io.r2dbc.h2.codecs.ByteBufferInputStream;
import io.r2dbc.h2.util.Assert;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Iterator;
import org.h2.value.Value;
import org.h2.value.ValueBlob;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

final class BlobToByteBufferCodec
extends AbstractCodec<ByteBuffer> {
    private final Client client;

    BlobToByteBufferCodec(Client client) {
        super(ByteBuffer.class);
        this.client = client;
    }

    @Override
    boolean doCanDecode(int dataType) {
        return dataType == 7;
    }

    @Override
    ByteBuffer doDecode(Value value, Class<? extends ByteBuffer> type) {
        if (value == null || value instanceof ValueNull) {
            return null;
        }
        byte[] bytes = value.getBytesNoCopy();
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        buffer.flip();
        return buffer;
    }

    @Override
    Value doEncode(ByteBuffer value) {
        Assert.requireNonNull(value, "value must not be null");
        ValueBlob blob = this.client.getSession().getDataHandler().getLobStorage().createBlob((InputStream)new SequenceInputStream(new BlobInputStreamEnumeration(value)), -1L);
        this.client.getSession().addTemporaryLob((ValueLob)blob);
        return blob;
    }

    private final class BlobInputStreamEnumeration
    implements Enumeration<InputStream> {
        private final Iterator<ByteBufferInputStream> inputStreams;

        BlobInputStreamEnumeration(ByteBuffer value) {
            this.inputStreams = Flux.just((Object)value).map(ByteBufferInputStream::new).subscribeOn(Schedulers.boundedElastic()).cancelOn(Schedulers.boundedElastic()).toIterable().iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.inputStreams.hasNext();
        }

        @Override
        public InputStream nextElement() {
            return this.inputStreams.next();
        }
    }
}

