/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.StringCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.net.MalformedURLException;
import java.net.URL;
import reactor.util.annotation.Nullable;

final class UrlCodec
extends AbstractCodec<URL> {
    private final StringCodec delegate;

    UrlCodec(ByteBufAllocator byteBufAllocator) {
        super(URL.class);
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.delegate = new StringCodec(byteBufAllocator);
    }

    @Override
    public Parameter doEncode(URL value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.delegate.doEncode(value.toString());
    }

    @Override
    public Parameter encodeNull() {
        return this.delegate.encodeNull();
    }

    @Override
    public Iterable<PostgresqlObjectId> getDataTypes() {
        return this.delegate.getDataTypes();
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return this.delegate.doCanDecode(type, format);
    }

    @Override
    URL doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends URL> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        try {
            return new URL(((String)this.delegate.doDecode(buffer, dataType, format, String.class)).trim());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

