/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import rx.Observable;
import rx.Subscriber;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.CompositeSubscription;

public final class OperatorMergeMaxConcurrent<T>
implements Observable.Operator<T, Observable<? extends T>> {
    final int maxConcurrency;

    public OperatorMergeMaxConcurrent(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    public Subscriber<? super Observable<? extends T>> call(Subscriber<? super T> child) {
        SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        CompositeSubscription csub = new CompositeSubscription();
        child.add(csub);
        return new SourceSubscriber<T>(this.maxConcurrency, s, csub);
    }

    static final class SourceSubscriber<T>
    extends Subscriber<Observable<? extends T>> {
        final int maxConcurrency;
        final Subscriber<T> s;
        final CompositeSubscription csub;
        final Object guard;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<SourceSubscriber> WIP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SourceSubscriber.class, "wip");
        int active;
        final Queue<Observable<? extends T>> queue;

        public SourceSubscriber(int maxConcurrency, Subscriber<T> s, CompositeSubscription csub) {
            super(s);
            this.maxConcurrency = maxConcurrency;
            this.s = s;
            this.csub = csub;
            this.guard = new Object();
            this.queue = new LinkedList<Observable<? extends T>>();
            this.wip = 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(Observable<? extends T> t) {
            Object object = this.guard;
            synchronized (object) {
                this.queue.add(t);
            }
            this.subscribeNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void subscribeNext() {
            Observable<T> t;
            Object object = this.guard;
            synchronized (object) {
                t = this.queue.peek();
                if (t == null || this.active >= this.maxConcurrency) {
                    return;
                }
                ++this.active;
                this.queue.poll();
            }
            Subscriber itemSub = new Subscriber<T>(){
                boolean once = true;

                @Override
                public void onNext(T t) {
                    SourceSubscriber.this.s.onNext(t);
                }

                @Override
                public void onError(Throwable e) {
                    SourceSubscriber.this.onError(e);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCompleted() {
                    if (this.once) {
                        this.once = false;
                        Object object = SourceSubscriber.this.guard;
                        synchronized (object) {
                            --SourceSubscriber.this.active;
                        }
                        SourceSubscriber.this.csub.remove(this);
                        SourceSubscriber.this.subscribeNext();
                        SourceSubscriber.this.onCompleted();
                    }
                }
            };
            this.csub.add(itemSub);
            WIP_UPDATER.incrementAndGet(this);
            t.unsafeSubscribe(itemSub);
        }

        @Override
        public void onError(Throwable e) {
            this.s.onError(e);
            this.unsubscribe();
        }

        @Override
        public void onCompleted() {
            if (WIP_UPDATER.decrementAndGet(this) == 0) {
                this.s.onCompleted();
            }
        }
    }
}

