/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.schedulers;

import java.lang.reflect.Method;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.internal.schedulers.ScheduledAction;
import rx.plugins.RxJavaPlugins;
import rx.plugins.RxJavaSchedulersHook;
import rx.subscriptions.Subscriptions;

public class NewThreadWorker
extends Scheduler.Worker
implements Subscription {
    private final ScheduledExecutorService executor;
    private final RxJavaSchedulersHook schedulersHook;
    volatile boolean isUnsubscribed;

    public NewThreadWorker(ThreadFactory threadFactory) {
        this.executor = Executors.newScheduledThreadPool(1, threadFactory);
        for (Method m : this.executor.getClass().getMethods()) {
            if (!m.getName().equals("setRemoveOnCancelPolicy") || m.getParameterTypes().length != 1 || m.getParameterTypes()[0] != Boolean.TYPE) continue;
            try {
                m.invoke((Object)this.executor, true);
            }
            catch (Exception ex) {
                RxJavaPlugins.getInstance().getErrorHandler().handleError(ex);
            }
            break;
        }
        this.schedulersHook = RxJavaPlugins.getInstance().getSchedulersHook();
    }

    @Override
    public Subscription schedule(Action0 action) {
        return this.schedule(action, 0L, null);
    }

    @Override
    public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
        if (this.isUnsubscribed) {
            return Subscriptions.unsubscribed();
        }
        return this.scheduleActual(action, delayTime, unit);
    }

    public ScheduledAction scheduleActual(Action0 action, long delayTime, TimeUnit unit) {
        Action0 decoratedAction = this.schedulersHook.onSchedule(action);
        ScheduledAction run = new ScheduledAction(decoratedAction);
        Future<?> f = delayTime <= 0L ? this.executor.submit(run) : this.executor.schedule(run, delayTime, unit);
        run.add(f);
        return run;
    }

    @Override
    public void unsubscribe() {
        this.isUnsubscribed = true;
        this.executor.shutdownNow();
    }

    @Override
    public boolean isUnsubscribed() {
        return this.isUnsubscribed;
    }
}

