package io.searchbox.cluster;

import io.searchbox.action.AbstractMultiINodeActionBuilder;
import io.searchbox.action.GenericResultAbstractAction;

/**
 * @author Dogukan Sonmez
 * @author cihat keser
 */
public class NodesInfo extends GenericResultAbstractAction {

    public NodesInfo(Builder builder) {
        super(builder);
        setPathToResult("nodes");
        setURI(buildURI());
    }

    protected String buildURI() {
        StringBuilder sb = new StringBuilder(super.buildURI());
        sb.append("/_nodes").append("/").append(nodes);
        return sb.toString();
    }

    @Override
    public String getRestMethodName() {
        return "GET";
    }

    public static class Builder extends AbstractMultiINodeActionBuilder<NodesInfo, Builder> {

        public Builder withSettings() {
            return addCleanApiParameter("settings");
        }

        public Builder withOs() {
            return addCleanApiParameter("os");
        }

        public Builder withProcess() {
            return addCleanApiParameter("process");
        }

        public Builder withJvm() {
            return addCleanApiParameter("jvm");
        }

        public Builder withThreadPool() {
            return addCleanApiParameter("thread_pool");
        }

        public Builder withNetwork() {
            return addCleanApiParameter("network");
        }

        public Builder withTransport() {
            return addCleanApiParameter("transport");
        }

        public Builder withHttp() {
            return addCleanApiParameter("http");
        }

        public Builder withPlugins() {
            return addCleanApiParameter("plugins");
        }

        @Override
        public NodesInfo build() {
            return new NodesInfo(this);
        }

    }
}

