/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client;

import com.google.gson.Gson;
import io.searchbox.client.JestClient;
import io.searchbox.client.config.ClientConfig;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.client.config.discovery.NodeChecker;
import io.searchbox.client.config.idle.HttpReapableConnectionManager;
import io.searchbox.client.config.idle.IdleConnectionReaper;
import io.searchbox.client.config.idle.ReapableConnectionManager;
import io.searchbox.client.http.JestHttpClient;
import java.util.Map;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestClientFactory {
    static final Logger log = LoggerFactory.getLogger(JestClientFactory.class);
    private HttpClientConfig httpClientConfig;

    public JestClient getObject() {
        JestHttpClient client = new JestHttpClient();
        if (this.httpClientConfig == null) {
            log.debug("There is no configuration to create http client. Going to create simple client with default values");
            this.httpClientConfig = new HttpClientConfig.Builder("http://localhost:9200").build();
        }
        client.setRequestCompressionEnabled(this.httpClientConfig.isRequestCompressionEnabled());
        client.setServers(this.httpClientConfig.getServerList());
        HttpClientConnectionManager connectionManager = this.getConnectionManager();
        client.setHttpClient(this.createHttpClient(connectionManager));
        Gson gson = this.httpClientConfig.getGson();
        if (gson == null) {
            log.info("Using default GSON instance");
        } else {
            log.info("Using custom GSON instance");
            client.setGson(gson);
        }
        if (this.httpClientConfig.isDiscoveryEnabled()) {
            log.info("Node Discovery enabled...");
            NodeChecker nodeChecker = new NodeChecker((JestClient)client, (ClientConfig)this.httpClientConfig);
            client.setNodeChecker(nodeChecker);
            nodeChecker.startAsync();
            nodeChecker.awaitRunning();
        } else {
            log.info("Node Discovery disabled...");
        }
        if (this.httpClientConfig.getMaxConnectionIdleTime() > 0L) {
            log.info("Idle connection reaping enabled...");
            IdleConnectionReaper reaper = new IdleConnectionReaper((ClientConfig)this.httpClientConfig, (ReapableConnectionManager)new HttpReapableConnectionManager(connectionManager));
            client.setIdleConnectionReaper(reaper);
            reaper.startAsync();
            reaper.awaitRunning();
        } else {
            log.info("Idle connection reaping disabled...");
        }
        client.setAsyncClient(HttpAsyncClients.custom().setRoutePlanner(this.getRoutePlanner()).build());
        return client;
    }

    public void setHttpClientConfig(HttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }

    private CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager) {
        return this.configureHttpClient(HttpClients.custom().setConnectionManager(connectionManager).setDefaultRequestConfig(this.getRequestConfig()).setProxyAuthenticationStrategy(this.httpClientConfig.getProxyAuthenticationStrategy()).setRoutePlanner(this.getRoutePlanner()).setDefaultCredentialsProvider(this.httpClientConfig.getCredentialsProvider())).build();
    }

    protected HttpClientBuilder configureHttpClient(HttpClientBuilder builder) {
        return builder;
    }

    protected HttpRoutePlanner getRoutePlanner() {
        return this.httpClientConfig.getHttpRoutePlanner();
    }

    protected RequestConfig getRequestConfig() {
        return RequestConfig.custom().setConnectionRequestTimeout(this.httpClientConfig.getConnTimeout()).setSocketTimeout(this.httpClientConfig.getReadTimeout()).build();
    }

    protected HttpClientConnectionManager getConnectionManager() {
        BasicHttpClientConnectionManager retval;
        Registry registry = RegistryBuilder.create().register("http", (Object)this.httpClientConfig.getPlainSocketFactory()).register("https", (Object)this.httpClientConfig.getSslSocketFactory()).build();
        if (this.httpClientConfig.isMultiThreaded()) {
            Integer defaultMaxPerRoute;
            log.info("Using multi thread/connection supporting pooling connection manager");
            PoolingHttpClientConnectionManager poolingConnMgr = new PoolingHttpClientConnectionManager(registry);
            Integer maxTotal = this.httpClientConfig.getMaxTotalConnection();
            if (maxTotal != null) {
                poolingConnMgr.setMaxTotal(maxTotal.intValue());
            }
            if ((defaultMaxPerRoute = this.httpClientConfig.getDefaultMaxTotalConnectionPerRoute()) != null) {
                poolingConnMgr.setDefaultMaxPerRoute(defaultMaxPerRoute.intValue());
            }
            Map<HttpRoute, Integer> maxPerRoute = this.httpClientConfig.getMaxTotalConnectionPerRoute();
            for (Map.Entry<HttpRoute, Integer> entry : maxPerRoute.entrySet()) {
                poolingConnMgr.setMaxPerRoute(entry.getKey(), entry.getValue().intValue());
            }
            retval = poolingConnMgr;
        } else {
            log.info("Using single thread/connection supporting basic connection manager");
            retval = new BasicHttpClientConnectionManager((Lookup)registry);
        }
        return retval;
    }
}

