/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.auth.AuthDefinition;
import io.serverlessworkflow.api.auth.BasicAuthDefinition;
import io.serverlessworkflow.api.auth.BearerAuthDefinition;
import io.serverlessworkflow.api.auth.OauthDefinition;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import java.io.IOException;

public class AuthDefinitionDeserializer
extends StdDeserializer<AuthDefinition> {
    private static final long serialVersionUID = 510L;
    private WorkflowPropertySource context;

    public AuthDefinitionDeserializer() {
        this(AuthDefinition.class);
    }

    public AuthDefinitionDeserializer(Class<?> vc) {
        super(vc);
    }

    public AuthDefinitionDeserializer(WorkflowPropertySource context) {
        this(AuthDefinition.class);
        this.context = context;
    }

    public AuthDefinition deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        AuthDefinition authDefinition = new AuthDefinition();
        if (node.get("name") != null) {
            authDefinition.setName(node.get("name").asText());
        }
        if (node.get("scheme") != null) {
            authDefinition.setScheme(AuthDefinition.Scheme.fromValue(node.get("scheme").asText()));
        }
        if (node.get("properties") != null) {
            JsonNode propsNode = node.get("properties");
            if (propsNode.get("grantType") != null) {
                authDefinition.setOauth((OauthDefinition)mapper.treeToValue((TreeNode)propsNode, OauthDefinition.class));
            } else if (propsNode.get("token") != null) {
                authDefinition.setBearerauth((BearerAuthDefinition)mapper.treeToValue((TreeNode)propsNode, BearerAuthDefinition.class));
            } else {
                authDefinition.setBasicauth((BasicAuthDefinition)mapper.treeToValue((TreeNode)propsNode, BasicAuthDefinition.class));
            }
        }
        return authDefinition;
    }
}

