/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.utils.Utils;
import io.serverlessworkflow.api.workflow.Constants;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantsDeserializer
extends StdDeserializer<Constants> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(ConstantsDeserializer.class);
    private WorkflowPropertySource context;

    public ConstantsDeserializer() {
        this(Constants.class);
    }

    public ConstantsDeserializer(Class<?> vc) {
        super(vc);
    }

    public ConstantsDeserializer(WorkflowPropertySource context) {
        this(Constants.class);
        this.context = context;
    }

    public Constants deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Constants constants = new Constants();
        JsonNode constantsDefinition = null;
        if (node.isObject()) {
            constantsDefinition = node;
        } else {
            String constantsFileDef = node.asText();
            String constantsFileSrc = Utils.getResourceFileAsString(constantsFileDef);
            if (constantsFileSrc != null && constantsFileSrc.trim().length() > 0) {
                JsonNode constantsRefNode = Utils.getNode(constantsFileSrc);
                JsonNode refConstants = constantsRefNode.get("constants");
                if (refConstants != null) {
                    constantsDefinition = refConstants;
                } else {
                    logger.error("Unable to find constants definitions in reference file: {}", (Object)constantsFileSrc);
                }
            } else {
                logger.error("Unable to load constants defs reference file: {}", (Object)constantsFileSrc);
            }
        }
        constants.setConstantsDef(constantsDefinition);
        return constants;
    }
}

