/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.datainputschema.DataInputSchema;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import java.io.IOException;

public class DataInputSchemaDeserializer
extends StdDeserializer<DataInputSchema> {
    private static final long serialVersionUID = 510L;

    public DataInputSchemaDeserializer() {
        this(DataInputSchema.class);
    }

    public DataInputSchemaDeserializer(Class<?> vc) {
        super(vc);
    }

    public DataInputSchemaDeserializer(WorkflowPropertySource context) {
        this(DataInputSchema.class);
    }

    public DataInputSchema deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        DataInputSchema dataInputSchema = new DataInputSchema();
        if (!node.isObject()) {
            dataInputSchema.setSchema(node.asText());
            dataInputSchema.setFailOnValidationErrors(true);
            return dataInputSchema;
        }
        dataInputSchema.setSchema(node.get("schema").asText());
        dataInputSchema.setFailOnValidationErrors(node.get("failOnValidationErrors").asBoolean());
        return dataInputSchema;
    }
}

