/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.functions.FunctionRef;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import java.io.IOException;

public class FunctionRefDeserializer
extends StdDeserializer<FunctionRef> {
    private static final long serialVersionUID = 510L;
    private WorkflowPropertySource context;

    public FunctionRefDeserializer() {
        this(FunctionRef.class);
    }

    public FunctionRefDeserializer(Class<?> vc) {
        super(vc);
    }

    public FunctionRefDeserializer(WorkflowPropertySource context) {
        this(FunctionRef.class);
        this.context = context;
    }

    public FunctionRef deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        FunctionRef functionRef = new FunctionRef();
        if (!node.isObject()) {
            functionRef.setRefName(node.asText());
            functionRef.setArguments(null);
            functionRef.setInvoke(FunctionRef.Invoke.SYNC);
            return functionRef;
        }
        if (node.get("arguments") != null) {
            functionRef.setArguments((JsonNode)mapper.treeToValue((TreeNode)node.get("arguments"), JsonNode.class));
        }
        if (node.get("refName") != null) {
            functionRef.setRefName(node.get("refName").asText());
        }
        if (node.get("selectionSet") != null) {
            functionRef.setSelectionSet(node.get("selectionSet").asText());
        }
        if (node.get("invoke") != null) {
            functionRef.setInvoke(FunctionRef.Invoke.fromValue(node.get("invoke").asText()));
        }
        return functionRef;
    }
}

