/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.produce;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"eventRef", "data", "contextAttributes"})
public class ProduceEvent
implements Serializable {
    @JsonProperty(value="eventRef")
    @JsonPropertyDescription(value="References a name of a defined event")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String eventRef;
    @JsonProperty(value="data")
    @JsonPropertyDescription(value="Workflow expression which selects parts of the states data output to become the data of the produced event")
    @Valid
    private JsonNode data;
    @JsonProperty(value="contextAttributes")
    @JsonPropertyDescription(value="Add additional event extension context attributes")
    @Valid
    private Map<String, String> contextAttributes;
    private static final long serialVersionUID = -292560959610496941L;

    public ProduceEvent() {
    }

    public ProduceEvent(String eventRef) {
        this.eventRef = eventRef;
    }

    @JsonProperty(value="eventRef")
    public String getEventRef() {
        return this.eventRef;
    }

    @JsonProperty(value="eventRef")
    public void setEventRef(String eventRef) {
        this.eventRef = eventRef;
    }

    public ProduceEvent withEventRef(String eventRef) {
        this.eventRef = eventRef;
        return this;
    }

    @JsonProperty(value="data")
    public JsonNode getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(JsonNode data) {
        this.data = data;
    }

    public ProduceEvent withData(JsonNode data) {
        this.data = data;
        return this;
    }

    @JsonProperty(value="contextAttributes")
    public Map<String, String> getContextAttributes() {
        return this.contextAttributes;
    }

    @JsonProperty(value="contextAttributes")
    public void setContextAttributes(Map<String, String> contextAttributes) {
        this.contextAttributes = contextAttributes;
    }

    public ProduceEvent withContextAttributes(Map<String, String> contextAttributes) {
        this.contextAttributes = contextAttributes;
        return this;
    }
}

