/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.dom4j.BaseHrefAttribute;
import io.sf.carte.doc.dom4j.BaseURLElement;
import io.sf.carte.doc.dom4j.CachedTableCellElement;
import io.sf.carte.doc.dom4j.CachedTableElement;
import io.sf.carte.doc.dom4j.CachedTableRowElement;
import io.sf.carte.doc.dom4j.CachedXHTMLElement;
import io.sf.carte.doc.dom4j.CenterElement;
import io.sf.carte.doc.dom4j.DOM4JCSSStyleDeclaration;
import io.sf.carte.doc.dom4j.DOM4JCSSStyleSheet;
import io.sf.carte.doc.dom4j.DOM4JDocumentCSSStyleSheet;
import io.sf.carte.doc.dom4j.DocumentStyleEventAttribute;
import io.sf.carte.doc.dom4j.FontElement;
import io.sf.carte.doc.dom4j.HeadElement;
import io.sf.carte.doc.dom4j.LinkElement;
import io.sf.carte.doc.dom4j.StrikeElement;
import io.sf.carte.doc.dom4j.StyleAttribute;
import io.sf.carte.doc.dom4j.StyleDefinerElement;
import io.sf.carte.doc.dom4j.StyleElement;
import io.sf.carte.doc.dom4j.TableCellElement;
import io.sf.carte.doc.dom4j.TableElement;
import io.sf.carte.doc.dom4j.TableRowElement;
import io.sf.carte.doc.dom4j.UnderlineElement;
import io.sf.carte.doc.dom4j.XHTMLDocument;
import io.sf.carte.doc.dom4j.XHTMLElement;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.LogErrorHandler;
import io.sf.carte.doc.style.css.dom.AbstractCSSRule;
import io.sf.carte.doc.style.css.dom.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.dom.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.dom.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.dom.DOMMediaList;
import io.sf.carte.doc.style.css.dom.DummyDeviceFactory;
import java.io.IOException;
import org.dom4j.Attribute;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMDocumentFactory;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;

public class XHTMLDocumentFactory
extends DOMDocumentFactory {
    private static final long serialVersionUID = 6L;
    private DOM4JDocumentCSSStyleSheet defStyleSheet = null;
    private DOM4JDocumentCSSStyleSheet uaStyleSheet = null;
    private DOM4JCSSStyleSheetFactory cssFactory = null;
    private boolean styleCacheOn = false;
    private DeviceFactory deviceFactory = new DummyDeviceFactory();
    private byte complianceMode = 0;
    private static transient XHTMLDocumentFactory singleton = new XHTMLDocumentFactory();

    protected XHTMLDocumentFactory() {
    }

    public static XHTMLDocumentFactory getInstance() {
        return singleton;
    }

    public DOM4JCSSStyleSheetFactory getStyleSheetFactory() {
        if (this.cssFactory == null) {
            this.cssFactory = new DOM4JCSSStyleSheetFactory(this.complianceMode);
        }
        return this.cssFactory;
    }

    public void setComplianceMode(byte complianceMode) {
        if (this.cssFactory != null) {
            throw new IllegalStateException("Style sheet factory already has a mode.");
        }
        if (complianceMode != 0 && complianceMode != 1) {
            throw new IllegalArgumentException("Unsupported operaton mode.");
        }
        this.complianceMode = complianceMode;
    }

    public DOM4JDocumentCSSStyleSheet getUserAgentStyleSheet() {
        if (this.uaStyleSheet == null) {
            try {
                this.uaStyleSheet = (DOM4JDocumentCSSStyleSheet)this.getStyleSheetFactory().loadXHTMLDefaultSheet();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load default User Agent style sheet.", e);
            }
        }
        return this.uaStyleSheet;
    }

    protected DOM4JDocumentCSSStyleSheet getDefaultStyleSheet() {
        if (this.defStyleSheet == null) {
            this.mergeUserSheets();
        }
        return this.defStyleSheet;
    }

    public void setUserAgentStyleSheet(DOM4JDocumentCSSStyleSheet styleSheet) {
        this.uaStyleSheet = styleSheet;
        this.defStyleSheet = null;
    }

    private void mergeUserSheets() {
        this.defStyleSheet = this.getUserAgentStyleSheet().clone();
        if (this.getStyleSheetFactory().getUserNormalStyleSheet() != null) {
            this.defStyleSheet.addStyleSheet(this.getStyleSheetFactory().getUserNormalStyleSheet());
        }
    }

    public boolean isStyleCacheOn() {
        return this.styleCacheOn;
    }

    public void setStyleCache(boolean onOff) {
        this.styleCacheOn = onOff;
    }

    public Element createElement(QName qname) {
        String name = qname.getName();
        if ("base".equals(name)) {
            return new BaseURLElement(qname);
        }
        if ("style".equals(name)) {
            return new StyleElement(qname);
        }
        if ("link".equals(name)) {
            return new LinkElement(qname);
        }
        if ("head".equals(name)) {
            return new HeadElement(qname);
        }
        if ("title".equals(name) || "meta".equals(name)) {
            return new XHTMLElement(qname);
        }
        if ("font".equals(name) || "basefont".equals(name)) {
            return new FontElement(qname);
        }
        if ("center".equals(name)) {
            return new CenterElement(qname);
        }
        if ("u".equals(name)) {
            return new UnderlineElement(qname);
        }
        if ("s".equals(name) || "strike".equals(name)) {
            return new StrikeElement(qname);
        }
        if (this.styleCacheOn) {
            if ("td".equals(name) || "th".equals(name)) {
                return new CachedTableCellElement(qname);
            }
            if ("tr".equals(name)) {
                return new CachedTableRowElement(qname);
            }
            if ("table".equals(name)) {
                return new CachedTableElement(qname);
            }
            return new CachedXHTMLElement(qname);
        }
        if ("td".equals(name) || "th".equals(name)) {
            return new TableCellElement(qname);
        }
        if ("tr".equals(name)) {
            return new TableRowElement(qname);
        }
        if ("table".equals(name)) {
            return new TableElement(qname);
        }
        return new XHTMLElement(qname);
    }

    public Element createElement(QName qname, int attributeCount) {
        String name = qname.getName();
        if ("base".equals(name)) {
            return new BaseURLElement(qname, attributeCount);
        }
        if ("style".equals(name)) {
            return new StyleElement(qname, attributeCount);
        }
        if ("link".equals(name)) {
            return new LinkElement(qname, attributeCount);
        }
        if ("head".equals(name)) {
            return new HeadElement(qname, attributeCount);
        }
        if ("title".equals(name) || "meta".equals(name)) {
            return new XHTMLElement(qname, attributeCount);
        }
        if ("font".equals(name) || "basefont".equals(name)) {
            return new FontElement(qname, attributeCount);
        }
        if ("center".equals(name)) {
            return new CenterElement(qname, attributeCount);
        }
        if ("u".equals(name)) {
            return new UnderlineElement(qname, attributeCount);
        }
        if ("s".equals(name) || "strike".equals(name)) {
            return new StrikeElement(qname, attributeCount);
        }
        if (this.styleCacheOn) {
            if ("td".equals(name) || "th".equals(name)) {
                return new CachedTableCellElement(qname, attributeCount);
            }
            if ("tr".equals(name)) {
                return new CachedTableRowElement(qname, attributeCount);
            }
            if ("table".equals(name)) {
                return new CachedTableElement(qname, attributeCount);
            }
            return new CachedXHTMLElement(qname, attributeCount);
        }
        if ("td".equals(name) || "th".equals(name)) {
            return new TableCellElement(qname, attributeCount);
        }
        if ("tr".equals(name)) {
            return new TableRowElement(qname, attributeCount);
        }
        if ("table".equals(name)) {
            return new TableElement(qname, attributeCount);
        }
        return new XHTMLElement(qname, attributeCount);
    }

    public XHTMLDocument createDocument() {
        XHTMLDocument mydoc = new XHTMLDocument();
        mydoc.setDocumentFactory((DocumentFactory)this);
        mydoc.setDefaultStyleSheet(this.getDefaultStyleSheet());
        return mydoc;
    }

    public Attribute createAttribute(Element owner, QName qname, String value) {
        if (owner instanceof StyleDefinerElement) {
            return new DocumentStyleEventAttribute(qname, value);
        }
        if (owner instanceof BaseURLElement && qname.getName().equals("href")) {
            return new BaseHrefAttribute(qname, value);
        }
        if (owner instanceof CachedXHTMLElement && qname.getName().equals("style")) {
            return new StyleAttribute(qname, value);
        }
        return super.createAttribute(owner, qname, value);
    }

    public DeviceFactory getDeviceFactory() {
        return this.deviceFactory;
    }

    public void setDeviceFactory(DeviceFactory deviceFactory) {
        this.deviceFactory = deviceFactory;
    }

    public class DOM4JCSSStyleSheetFactory
    extends BaseCSSStyleSheetFactory {
        private ErrorHandler errorHandler;

        DOM4JCSSStyleSheetFactory(byte complianceMode) {
            super(complianceMode);
            this.errorHandler = this.createErrorHandler();
        }

        protected AbstractCSSStyleSheet getUserImportantStyleSheet() {
            return super.getUserImportantStyleSheet();
        }

        protected AbstractCSSStyleSheet getUserNormalStyleSheet() {
            return super.getUserNormalStyleSheet();
        }

        public AbstractCSSStyleDeclaration createAnonymousStyleDeclaration(Node node, CSSElement parent) {
            DOM4JCSSStyleDeclaration style = new DOM4JCSSStyleDeclaration();
            style.setOwnerNode(node);
            style.setStyleDatabase(parent.getOwnerDocument().getStyleDatabase());
            return style;
        }

        public DOM4JDocumentCSSStyleSheet createDocumentStyleSheet(short origin) {
            return new MyDOM4JDocumentCSSStyleSheet(null, origin);
        }

        public DOM4JCSSStyleSheet createRuleStyleSheet(AbstractCSSRule ownerRule, String title, DOMMediaList mediaList) {
            return new MyDOM4JCSSStyleSheet(title, null, mediaList, (CSSRule)ownerRule, ownerRule.getOrigin());
        }

        public DOM4JCSSStyleSheet createLinkedStyleSheet(CSSElement ownerElement, String title, DOMMediaList mediaList) {
            return new MyDOM4JCSSStyleSheet(title, ownerElement, mediaList, null, 8);
        }

        DOM4JCSSStyleSheet createCSSStyleSheet(String title, CSSElement ownerElement, DOMMediaList media, CSSRule ownerRule, short origin) {
            return new MyDOM4JCSSStyleSheet(title, ownerElement, media, ownerRule, origin);
        }

        DOM4JDocumentCSSStyleSheet createDocumentStyleSheet(String targetMedium, short origin) {
            return new MyDOM4JDocumentCSSStyleSheet(targetMedium, origin);
        }

        public void setDefaultHTMLUserAgentSheet() {
            try {
                XHTMLDocumentFactory.this.setUserAgentStyleSheet((DOM4JDocumentCSSStyleSheet)this.loadXHTMLDefaultSheet());
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read the default style sheet", e);
            }
        }

        protected ErrorHandler createErrorHandler() {
            return new LogErrorHandler();
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        private class MyDOM4JCSSStyleSheet
        extends DOM4JCSSStyleSheet {
            public MyDOM4JCSSStyleSheet(String title, CSSElement ownerElement, DOMMediaList media, CSSRule ownerRule, short origin) {
                super(title, ownerElement, media, ownerRule, origin);
            }

            public BaseCSSStyleSheetFactory getStyleSheetFactory() {
                return DOM4JCSSStyleSheetFactory.this;
            }
        }

        private class MyDOM4JDocumentCSSStyleSheet
        extends DOM4JDocumentCSSStyleSheet {
            public MyDOM4JDocumentCSSStyleSheet(String targetMedium, short origin) {
                super(targetMedium, origin);
            }

            public BaseCSSStyleSheetFactory getStyleSheetFactory() {
                return DOM4JCSSStyleSheetFactory.this;
            }
        }
    }
}

