/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.XHTMLDocument;
import io.sf.carte.doc.dom4j.XHTMLElement;
import java.net.MalformedURLException;
import java.net.URL;
import org.dom4j.Attribute;
import org.dom4j.Node;
import org.dom4j.QName;

class BaseURLElement
extends XHTMLElement {
    transient URL base = null;
    private static final long serialVersionUID = 2L;

    BaseURLElement(String name) {
        super(name);
    }

    BaseURLElement(QName qname) {
        super(qname);
    }

    BaseURLElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    protected void childAdded(Node node) {
        String href;
        super.childAdded(node);
        if (node instanceof Attribute && node.getName().equals("href") && (href = ((Attribute)node).getValue()) != null) {
            try {
                this.base = new URL(href);
            }
            catch (MalformedURLException e) {
                XHTMLDocument doc = this.getOwnerDocument();
                if (doc != null) {
                    doc.setBaseURL(null);
                }
                return;
            }
            XHTMLDocument doc = this.getOwnerDocument();
            if (doc != null) {
                doc.setBaseURL(this.base);
            }
        }
    }

    @Override
    protected void childRemoved(Node node) {
        super.childRemoved(node);
        if (node instanceof Attribute && node.getName().equals("href")) {
            this.base = null;
            this.getOwnerDocument().setBaseURL(null);
        }
    }
}

