/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.DOM4JCSSStyleSheet;
import io.sf.carte.doc.dom4j.StyleDefinerElement;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.MediaQueryFactory;
import io.sf.carte.doc.style.css.om.OMMediaList;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.dom4j.QName;
import org.w3c.css.sac.CSSException;
import org.w3c.dom.css.CSSStyleSheet;

class LinkElement
extends StyleDefinerElement {
    private static final long serialVersionUID = 2L;

    LinkElement(String name) {
        super(name);
    }

    LinkElement(QName qname) {
        super(qname);
    }

    LinkElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    public DOM4JCSSStyleSheet getSheet() {
        if (this.needsUpdate) {
            String type = this.attributeValue("type");
            if (type != null && !"text/css".equals(type)) {
                return null;
            }
            String rel = this.attributeValue("rel");
            if (rel != null) {
                String href;
                String title = this.attributeValue("title");
                String lcrel = rel.toLowerCase(Locale.US);
                if (lcrel.equals("stylesheet")) {
                    String href2 = this.attributeValue("href");
                    if (href2 != null && href2.length() != 0) {
                        this.loadStyleSheet(href2, title);
                    }
                } else if (lcrel.equals("alternate stylesheet") && title != null && (href = this.attributeValue("href")) != null) {
                    this.loadStyleSheet(href, title);
                    this.linkedSheet.setDisabled(true);
                }
                this.needsUpdate = false;
            }
        }
        return this.linkedSheet;
    }

    private void loadStyleSheet(String href, String title) {
        String media = this.attributeValue("media");
        if (this.linkedSheet == null) {
            OMMediaList mediaList;
            if (media == null || media.trim().length() == 0) {
                mediaList = OMMediaList.createMediaList();
            } else {
                mediaList = MediaQueryFactory.createMediaList((String)media);
                if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                    this.getDocumentFactory().getStyleSheetFactory().getErrorHandler().mediaQueryError(media);
                }
            }
            this.linkedSheet = this.getDocumentFactory().getStyleSheetFactory().createLinkedStyleSheet(this, title, (MediaQueryList)mediaList);
        } else {
            this.linkedSheet.setDestinationMedia(media);
        }
        try {
            URL url = this.getOwnerDocument().getURL(href);
            this.linkedSheet.setHref(url.toExternalForm());
            this.linkedSheet.loadStyleSheet(url);
        }
        catch (CSSException e) {
            this.getDocumentFactory().getStyleSheetFactory().getErrorHandler().onException((Exception)((Object)e), (CSSStyleSheet)((Object)this.linkedSheet));
        }
        catch (IOException e) {
            this.getDocumentFactory().getStyleSheetFactory().getErrorHandler().onException((Exception)e, (CSSStyleSheet)((Object)this.linkedSheet));
        }
    }
}

