/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.XHTMLElement;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import java.util.Iterator;
import org.dom4j.Element;
import org.dom4j.QName;

class CachedXHTMLElement
extends XHTMLElement {
    private static final long serialVersionUID = 3L;
    private ComputedCSSStyle cachedComputedStyle = null;
    private int cacheSerial = Integer.MIN_VALUE;

    CachedXHTMLElement(String name) {
        super(name);
    }

    CachedXHTMLElement(QName qname) {
        super(qname);
    }

    CachedXHTMLElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    public ComputedCSSStyle getComputedStyle() {
        int documentCacheSerial = this.getOwnerDocument().getStyleCacheSerial();
        if (this.cachedComputedStyle == null || this.cacheSerial != documentCacheSerial) {
            this.cacheSerial = documentCacheSerial;
            this.cachedComputedStyle = super.getComputedStyle();
        }
        return this.cachedComputedStyle;
    }

    public void onStyleModify() {
        this.cachedComputedStyle = null;
        Iterator elements = this.elementIterator();
        while (elements.hasNext()) {
            Element element = (Element)elements.next();
            if (!(element instanceof CachedXHTMLElement)) continue;
            ((CachedXHTMLElement)element).onStyleModify();
        }
        this.getDocument().onStyleModify();
    }
}

