/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.CSSStylableElement;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.om.BoxModelHelper;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import org.dom4j.Node;
import org.dom4j.dom.DOMElement;

abstract class DOM4JComputedStyle
extends ComputedCSSStyle {
    private transient ComputedCSSStyle parentStyle = null;

    DOM4JComputedStyle(CSSElement ownerNode) {
        this.setOwnerNode(ownerNode);
    }

    DOM4JComputedStyle(ComputedCSSStyle copiedObject) {
        super(copiedObject);
    }

    public ComputedCSSStyle getParentComputedStyle() {
        if (this.parentStyle == null) {
            Object node = this.getOwnerNode();
            while (node != null && (node = node.getParentNode()) != null) {
                if (node.getNodeType() != 1) continue;
                this.parentStyle = ((CSSStylableElement)((Object)node)).getComputedStyle();
                break;
            }
        }
        return this.parentStyle;
    }

    public String getText() {
        CSSElement node = this.getOwnerNode();
        String text = node instanceof DOMElement ? ((DOMElement)node).getTextTrim() : (node instanceof Node ? BoxModelHelper.contractSpaces((String)((Node)node).getText()) : "");
        return text.trim();
    }

    public StyleDatabase getStyleDatabase() {
        CSSElement node = this.getOwnerNode();
        if (node != null) {
            CSSDocument doc = (CSSDocument)node.getOwnerDocument();
            return doc.getStyleDatabase();
        }
        return null;
    }
}

