/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.BaseURLElement;
import io.sf.carte.doc.dom4j.XHTMLElement;
import org.dom4j.Node;
import org.dom4j.QName;
import org.w3c.dom.Element;

class HeadElement
extends XHTMLElement {
    private static final long serialVersionUID = 3L;

    HeadElement(String name) {
        super(name);
    }

    HeadElement(QName qname) {
        super(qname);
    }

    HeadElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    protected void childAdded(Node node) {
        super.childAdded(node);
        if (node instanceof BaseURLElement) {
            this.getOwnerDocument().setBaseURL(((BaseURLElement)node).base);
            ((BaseURLElement)node).base = null;
        } else if ("meta".equalsIgnoreCase(node.getName())) {
            Element elt = (Element)node;
            String name = elt.getAttribute("http-equiv");
            if (name.length() == 0) {
                name = elt.getAttribute("name");
            }
            this.getOwnerDocument().onMetaAdded(name, elt.getAttribute("content"));
        }
    }

    @Override
    protected void childRemoved(Node node) {
        if ("meta".equalsIgnoreCase(node.getName())) {
            Element elt = (Element)node;
            String name = elt.getAttribute("http-equiv");
            if (name.length() == 0) {
                name = elt.getAttribute("name");
            }
            this.getOwnerDocument().onMetaRemoved(name, elt.getAttribute("content"));
        }
        super.childRemoved(node);
    }
}

