/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.DOM4JCSSStyleSheet;
import io.sf.carte.doc.dom4j.StyleDefinerElement;
import io.sf.carte.doc.dom4j.XHTMLDocument;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.MediaList;
import java.net.URL;
import org.dom4j.QName;
import org.w3c.css.sac.CSSException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleSheet;

class LinkElement
extends StyleDefinerElement {
    private static final long serialVersionUID = 2L;

    LinkElement(String name) {
        super(name);
    }

    LinkElement(QName qname) {
        super(qname);
    }

    LinkElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    public AbstractCSSStyleSheet getSheet() {
        if (this.needsUpdate) {
            String nsuri = this.getNamespaceURI();
            if (nsuri.length() != 0 && !nsuri.equals("http://www.w3.org/1999/xhtml")) {
                return null;
            }
            String rel = this.getAttribute("rel");
            String type = this.getAttribute("type");
            int typelen = type.length();
            if (typelen == 0 ? rel.length() == 0 : !"text/css".equalsIgnoreCase(type)) {
                return null;
            }
            byte relAttr = AbstractCSSStyleSheet.parseRelAttribute((String)rel);
            if (relAttr != -1) {
                String href = this.attributeValue("href");
                String title = this.attributeValue("title");
                if (title != null && (title = title.trim()).length() == 0) {
                    title = null;
                }
                if (href != null && href.length() != 0) {
                    if (relAttr == 0) {
                        if (href != null && href.length() != 0) {
                            this.loadStyleSheet(href, title);
                        }
                    } else if (title != null) {
                        if (href != null && href.length() != 0) {
                            XHTMLDocument doc = this.getDocument();
                            boolean disable = this.linkedSheet == null || (doc = this.getDocument()) != null && !title.equalsIgnoreCase(doc.getSelectedStyleSheetSet());
                            this.loadStyleSheet(href, title);
                            if (disable) {
                                this.linkedSheet.setDisabled(true);
                            }
                        }
                    } else {
                        this.getErrorHandler().linkedStyleError((Node)((Object)this), "Alternate sheet without title");
                    }
                    this.needsUpdate = false;
                } else {
                    this.getErrorHandler().linkedStyleError((Node)((Object)this), "Missing or void href attribute.");
                }
            } else {
                this.linkedSheet = null;
            }
        }
        return this.linkedSheet;
    }

    private void loadStyleSheet(String href, String title) {
        MediaList mediaList;
        String media = this.attributeValue("media");
        if (media == null || media.trim().length() == 0) {
            mediaList = MediaList.createMediaList();
        } else {
            mediaList = this.getDocumentFactory().getStyleSheetFactory().createMediaQueryList(media, (Node)((Object)this));
            if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                this.linkedSheet = null;
                return;
            }
        }
        if (this.linkedSheet == null) {
            this.linkedSheet = this.getDocumentFactory().createLinkedStyleSheet((Node)((Object)this), title, (MediaQueryList)mediaList);
        } else {
            DOM4JCSSStyleSheet mysheet = (DOM4JCSSStyleSheet)this.linkedSheet;
            mysheet.setMedia((MediaQueryList)mediaList);
            mysheet.setTitle(title);
            mysheet.getCssRules().clear();
        }
        String referrerPolicy = this.attributeValue("referrerpolicy");
        if (referrerPolicy == null) {
            referrerPolicy = "";
        }
        try {
            URL url = this.getOwnerDocument().getURL(href);
            this.linkedSheet.setHref(url.toExternalForm());
            this.linkedSheet.loadStyleSheet(url, referrerPolicy);
        }
        catch (CSSException e) {
            this.getErrorHandler().linkedSheetError((Exception)((Object)e), (CSSStyleSheet)this.linkedSheet);
        }
        catch (Exception e) {
            this.getErrorHandler().linkedSheetError(e, (CSSStyleSheet)this.linkedSheet);
        }
    }
}

