/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.CSSStylableElement;
import io.sf.carte.doc.dom4j.CachedXHTMLElement;
import io.sf.carte.doc.dom4j.XHTMLDocument;
import io.sf.carte.doc.dom4j.XHTMLDocumentFactory;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

class StyleAttribute
extends DOMAttribute {
    private AbstractCSSStyleDeclaration inlineStyle = null;
    private static final long serialVersionUID = 3L;

    StyleAttribute(QName qname) {
        super(qname);
    }

    StyleAttribute(QName qname, String value) {
        super(qname, value);
    }

    StyleAttribute(Element parent, QName qname, String value) {
        super(parent, qname, value);
    }

    public XHTMLDocument getDocument() {
        return (XHTMLDocument)super.getDocument();
    }

    public CSSStylableElement getOwnerElement() {
        return (CSSStylableElement)((Object)super.getOwnerElement());
    }

    public String getValue() {
        return this.getStyle().getCssText();
    }

    public void setValue(String value) {
        super.setValue(value);
        if (this.inlineStyle != null) {
            this.setInlineStyle(value);
        } else {
            this.getStyle();
        }
        Element parent = this.getParent();
        if (parent instanceof CachedXHTMLElement) {
            ((CachedXHTMLElement)parent).onStyleModify();
        }
    }

    public AbstractCSSStyleDeclaration getStyle() {
        if (this.inlineStyle == null) {
            XHTMLDocument doc = this.getDocument();
            XHTMLDocumentFactory factory = doc != null ? doc.getDocumentFactory() : XHTMLDocumentFactory.getInstance();
            this.inlineStyle = factory.createInlineStyle((Node)((Object)this));
            this.setInlineStyle(super.getValue());
        }
        return this.inlineStyle;
    }

    void setInlineStyle(String value) {
        if (value == null) {
            value = "";
        }
        try {
            this.inlineStyle.setCssText(value);
        }
        catch (DOMException e) {
            this.getDocument().getErrorHandler().inlineStyleError((CSSElement)this.getOwnerElement(), (Exception)e, value);
        }
    }
}

