/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.DOM4JCSSStyleSheet;
import io.sf.carte.doc.dom4j.StyleDefinerElement;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.MediaList;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.QName;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleSheet;

class StyleElement
extends StyleDefinerElement {
    private static final long serialVersionUID = 2L;

    StyleElement(String name) {
        super(name);
    }

    StyleElement(QName qname) {
        super(qname);
    }

    StyleElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    public AbstractCSSStyleSheet getSheet() {
        if (this.needsUpdate) {
            MediaList mediaList;
            String nsuri = this.getNamespaceURI();
            if (nsuri.length() != 0 && !nsuri.equals("http://www.w3.org/1999/xhtml")) {
                return null;
            }
            String type = this.attributeValue("type");
            if (!"text/css".equalsIgnoreCase(type)) {
                return null;
            }
            String media = this.attributeValue("media");
            if (media == null || media.trim().length() == 0) {
                mediaList = MediaList.createMediaList();
            } else {
                mediaList = this.getDocumentFactory().getStyleSheetFactory().createMediaQueryList(media, (Node)((Object)this));
                if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                    return null;
                }
            }
            String title = this.attributeValue("title");
            if (title != null && (title = title.trim()).length() == 0) {
                title = null;
            }
            if (this.linkedSheet == null) {
                this.linkedSheet = this.getDocumentFactory().createLinkedStyleSheet((Node)((Object)this), title, (MediaQueryList)mediaList);
            } else {
                DOM4JCSSStyleSheet mysheet = (DOM4JCSSStyleSheet)this.linkedSheet;
                mysheet.setMedia((MediaQueryList)mediaList);
                mysheet.setTitle(title);
                this.linkedSheet.getCssRules().clear();
            }
            String styleText = this.getText();
            if (styleText.length() != 0) {
                this.linkedSheet.setHref(this.getBaseURI());
                InputSource source = new InputSource();
                StringReader re = new StringReader(styleText);
                source.setCharacterStream((Reader)re);
                try {
                    this.linkedSheet.parseStyleSheet(source);
                }
                catch (DOMException e) {
                    this.getErrorHandler().linkedSheetError((Exception)e, (CSSStyleSheet)this.linkedSheet);
                }
                catch (IOException e) {
                    this.getErrorHandler().linkedSheetError((Exception)e, (CSSStyleSheet)this.linkedSheet);
                }
            }
            this.needsUpdate = false;
        }
        return this.linkedSheet;
    }

    @Override
    void resetLinkedSheet() {
        super.resetLinkedSheet();
        if (this.linkedSheet != null) {
            this.getSheet();
        }
    }
}

