/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.BaseHrefAttribute;
import io.sf.carte.doc.dom4j.BaseURLElement;
import io.sf.carte.doc.dom4j.CSSStylableElement;
import io.sf.carte.doc.dom4j.CachedTableCellElement;
import io.sf.carte.doc.dom4j.CachedTableElement;
import io.sf.carte.doc.dom4j.CachedTableRowElement;
import io.sf.carte.doc.dom4j.CachedXHTMLElement;
import io.sf.carte.doc.dom4j.DOM4JCSSStyleSheet;
import io.sf.carte.doc.dom4j.DOM4JComputedStyle;
import io.sf.carte.doc.dom4j.DOM4JDocumentCSSStyleSheet;
import io.sf.carte.doc.dom4j.DocumentStyleEventAttribute;
import io.sf.carte.doc.dom4j.FontElement;
import io.sf.carte.doc.dom4j.HeadElement;
import io.sf.carte.doc.dom4j.ImgElement;
import io.sf.carte.doc.dom4j.LinkElement;
import io.sf.carte.doc.dom4j.StyleAttribute;
import io.sf.carte.doc.dom4j.StyleDefinerElement;
import io.sf.carte.doc.dom4j.StyleElement;
import io.sf.carte.doc.dom4j.TableCellElement;
import io.sf.carte.doc.dom4j.TableElement;
import io.sf.carte.doc.dom4j.TableRowElement;
import io.sf.carte.doc.dom4j.XHTMLDocument;
import io.sf.carte.doc.dom4j.XHTMLElement;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.nsac.Parser2;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CompatInlineStyle;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.InlineStyle;
import java.util.EnumSet;
import java.util.Locale;
import org.dom4j.Attribute;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMDocumentFactory;
import org.dom4j.dom.DOMDocumentType;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class XHTMLDocumentFactory
extends DOMDocumentFactory {
    private static final long serialVersionUID = 8L;
    private final DOM4JCSSStyleSheetFactory cssFactory;
    private boolean styleCacheOn = false;
    private static transient XHTMLDocumentFactory singleton = new XHTMLDocumentFactory();

    protected XHTMLDocumentFactory() {
        this(EnumSet.noneOf(Parser2.Flag.class));
    }

    public XHTMLDocumentFactory(EnumSet<Parser2.Flag> enumSet) {
        this.cssFactory = new DOM4JCSSStyleSheetFactory(enumSet);
        this.cssFactory.setDefaultHTMLUserAgentSheet();
    }

    public static XHTMLDocumentFactory getInstance() {
        return singleton;
    }

    public BaseCSSStyleSheetFactory getStyleSheetFactory() {
        return this.cssFactory;
    }

    InlineStyle createInlineStyle(Node owner) {
        return this.cssFactory.createInlineStyle(owner);
    }

    BaseCSSStyleSheet createLinkedStyleSheet(Node ownerNode, String title, MediaQueryList mediaList) {
        return this.cssFactory.createLinkedStyleSheet(ownerNode, title, mediaList);
    }

    BaseDocumentCSSStyleSheet getDefaultStyleSheet(CSSDocument.ComplianceMode mode) {
        return this.cssFactory.getDefaultStyleSheet(mode);
    }

    public boolean isStyleCacheOn() {
        return this.styleCacheOn;
    }

    public void setStyleCache(boolean onOff) {
        this.styleCacheOn = onOff;
    }

    public CSSStylableElement createElement(String name) {
        return (CSSStylableElement)super.createElement(name);
    }

    public CSSStylableElement createElement(QName qname) {
        String name = qname.getName().toLowerCase(Locale.ROOT);
        if ("base".equals(name)) {
            return new BaseURLElement(qname);
        }
        if ("style".equals(name)) {
            return new StyleElement(qname);
        }
        if ("link".equals(name)) {
            return new LinkElement(qname);
        }
        if ("head".equals(name)) {
            return new HeadElement(qname);
        }
        if ("img".equals(name)) {
            return new ImgElement(qname);
        }
        if ("title".equals(name) || "meta".equals(name)) {
            return new XHTMLElement(qname);
        }
        if ("font".equals(name) || "basefont".equals(name)) {
            return new FontElement(qname);
        }
        if (this.styleCacheOn) {
            if ("td".equals(name) || "th".equals(name)) {
                return new CachedTableCellElement(qname);
            }
            if ("tr".equals(name)) {
                return new CachedTableRowElement(qname);
            }
            if ("table".equals(name)) {
                return new CachedTableElement(qname);
            }
            return new CachedXHTMLElement(qname);
        }
        if ("td".equals(name) || "th".equals(name)) {
            return new TableCellElement(qname);
        }
        if ("tr".equals(name)) {
            return new TableRowElement(qname);
        }
        if ("table".equals(name)) {
            return new TableElement(qname);
        }
        return new XHTMLElement(qname);
    }

    public CSSStylableElement createElement(QName qname, int attributeCount) {
        String name = qname.getName().toLowerCase(Locale.ROOT);
        if ("base".equals(name)) {
            return new BaseURLElement(qname, attributeCount);
        }
        if ("style".equals(name)) {
            return new StyleElement(qname, attributeCount);
        }
        if ("link".equals(name)) {
            return new LinkElement(qname, attributeCount);
        }
        if ("head".equals(name)) {
            return new HeadElement(qname, attributeCount);
        }
        if ("img".equals(name)) {
            return new ImgElement(qname, attributeCount);
        }
        if ("title".equals(name) || "meta".equals(name)) {
            return new XHTMLElement(qname, attributeCount);
        }
        if ("font".equals(name) || "basefont".equals(name)) {
            return new FontElement(qname, attributeCount);
        }
        if (this.styleCacheOn) {
            if ("td".equals(name) || "th".equals(name)) {
                return new CachedTableCellElement(qname, attributeCount);
            }
            if ("tr".equals(name)) {
                return new CachedTableRowElement(qname, attributeCount);
            }
            if ("table".equals(name)) {
                return new CachedTableElement(qname, attributeCount);
            }
            return new CachedXHTMLElement(qname, attributeCount);
        }
        if ("td".equals(name) || "th".equals(name)) {
            return new TableCellElement(qname, attributeCount);
        }
        if ("tr".equals(name)) {
            return new TableRowElement(qname, attributeCount);
        }
        if ("table".equals(name)) {
            return new TableElement(qname, attributeCount);
        }
        return new XHTMLElement(qname, attributeCount);
    }

    public XHTMLDocument createDocument() {
        XHTMLDocument mydoc = new XHTMLDocument();
        mydoc.setDocumentFactory((DocumentFactory)this);
        return mydoc;
    }

    public XHTMLDocument createDocument(Element rootElement) {
        XHTMLDocument mydoc = this.createDocument();
        mydoc.setRootElement(rootElement);
        return mydoc;
    }

    public XHTMLDocument createDocument(String namespaceURI, String qualifiedName, DocumentType docType) throws DOMException {
        XHTMLDocument document;
        if (docType != null) {
            DOMDocumentType documentType = this.asDocumentType(docType);
            document = new XHTMLDocument(documentType);
        } else {
            document = new XHTMLDocument();
        }
        document.setDocumentFactory((DocumentFactory)this);
        if (qualifiedName != null) {
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            document.add((Element)this.createElement(this.createQName(qualifiedName, namespaceURI)));
        }
        return document;
    }

    public Attribute createAttribute(Element owner, QName qname, String value) {
        String name = qname.getName();
        if (owner instanceof StyleDefinerElement) {
            return new DocumentStyleEventAttribute(qname, value);
        }
        name = qname.getName();
        if (name.equals("href") && owner instanceof BaseURLElement) {
            return new BaseHrefAttribute(qname, value);
        }
        if (name.equalsIgnoreCase("style")) {
            return new StyleAttribute(qname, value);
        }
        return super.createAttribute(owner, qname, value);
    }

    class DOM4JCSSStyleSheetFactory
    extends BaseCSSStyleSheetFactory {
        private BaseDocumentCSSStyleSheet defStyleSheet;
        private BaseDocumentCSSStyleSheet defQStyleSheet;
        private BaseDocumentCSSStyleSheet uaStyleSheet;
        private BaseDocumentCSSStyleSheet uaQStyleSheet;

        public DOM4JCSSStyleSheetFactory(EnumSet<Parser2.Flag> enumSet) {
            super(enumSet);
            this.defStyleSheet = null;
            this.defQStyleSheet = null;
            this.uaStyleSheet = null;
            this.uaQStyleSheet = null;
        }

        protected AbstractCSSStyleSheet getUserImportantStyleSheet() {
            return super.getUserImportantStyleSheet();
        }

        protected AbstractCSSStyleSheet getUserNormalStyleSheet() {
            return super.getUserNormalStyleSheet();
        }

        public AbstractCSSStyleDeclaration createAnonymousStyleDeclaration(Node node) {
            return this.createInlineStyle(node);
        }

        protected BaseDocumentCSSStyleSheet createDocumentStyleSheet(byte origin) {
            return new MyDOM4JDocumentCSSStyleSheet(null, origin);
        }

        protected BaseCSSStyleSheet createRuleStyleSheet(AbstractCSSRule ownerRule, String title, MediaQueryList mediaList) {
            return new MyDOM4JCSSStyleSheet(title, null, mediaList, ownerRule, ownerRule.getOrigin());
        }

        protected BaseCSSStyleSheet createLinkedStyleSheet(Node ownerNode, String title, MediaQueryList mediaList) {
            return new MyDOM4JCSSStyleSheet(title, ownerNode, mediaList, null, 8);
        }

        DOM4JCSSStyleSheet createCSSStyleSheet(String title, Node ownerNode, MediaQueryList media, AbstractCSSRule ownerRule, byte origin) {
            return new MyDOM4JCSSStyleSheet(title, ownerNode, media, ownerRule, origin);
        }

        DOM4JDocumentCSSStyleSheet createDocumentStyleSheet(String targetMedium, byte origin) {
            return new MyDOM4JDocumentCSSStyleSheet(targetMedium, origin);
        }

        protected InlineStyle createInlineStyle(Node owner) {
            Object style = !this.hasCompatValueFlags() ? new MyInlineStyle(owner) : new MyCompatInlineStyle(owner);
            return style;
        }

        DOM4JComputedStyle createComputedStyle(CSSElement ownerNode) {
            return new MyDOM4JComputedStyle(ownerNode);
        }

        public BaseDocumentCSSStyleSheet getUserAgentStyleSheet(CSSDocument.ComplianceMode mode) {
            if (mode == CSSDocument.ComplianceMode.STRICT) {
                if (this.uaStyleSheet == null) {
                    this.uaStyleSheet = this.createDocumentStyleSheet((byte)16);
                }
                return this.uaStyleSheet;
            }
            if (this.uaQStyleSheet == null) {
                this.uaQStyleSheet = this.createDocumentStyleSheet((byte)16);
            }
            return this.uaQStyleSheet;
        }

        protected BaseDocumentCSSStyleSheet getDefaultStyleSheet(CSSDocument.ComplianceMode mode) {
            if (this.defStyleSheet == null) {
                this.mergeUserSheets();
            }
            BaseDocumentCSSStyleSheet sheet = mode == CSSDocument.ComplianceMode.STRICT ? this.defStyleSheet : this.defQStyleSheet;
            return sheet;
        }

        private void mergeUserSheets() {
            this.defStyleSheet = this.getUserAgentStyleSheet(CSSDocument.ComplianceMode.STRICT).clone();
            this.defQStyleSheet = this.getUserAgentStyleSheet(CSSDocument.ComplianceMode.QUIRKS).clone();
            AbstractCSSStyleSheet usersheet = this.getUserNormalStyleSheet();
            if (usersheet != null) {
                this.defStyleSheet.addStyleSheet(usersheet);
                this.defQStyleSheet.addStyleSheet(usersheet);
            }
        }

        public void setDefaultHTMLUserAgentSheet() {
            this.uaStyleSheet = this.htmlDefaultSheet();
            this.uaQStyleSheet = this.htmlQuirksDefaultSheet();
            this.defStyleSheet = null;
            this.defQStyleSheet = null;
        }

        private class MyDOM4JDocumentCSSStyleSheet
        extends DOM4JDocumentCSSStyleSheet {
            public MyDOM4JDocumentCSSStyleSheet(String targetMedium, byte origin) {
                super(targetMedium, origin);
            }

            @Override
            public DOM4JCSSStyleSheetFactory getStyleSheetFactory() {
                return DOM4JCSSStyleSheetFactory.this;
            }
        }

        private class MyDOM4JCSSStyleSheet
        extends DOM4JCSSStyleSheet {
            public MyDOM4JCSSStyleSheet(String title, Node ownerNode, MediaQueryList media, AbstractCSSRule ownerRule, byte origin) {
                super(title, ownerNode, media, ownerRule, origin);
            }

            public BaseCSSStyleSheetFactory getStyleSheetFactory() {
                return DOM4JCSSStyleSheetFactory.this;
            }
        }

        class MyInlineStyle
        extends InlineStyle {
            MyInlineStyle(Node owner) {
                this.setOwnerNode(owner);
            }

            MyInlineStyle(InlineStyle copiedObject) {
                super(copiedObject);
            }

            protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
                return DOM4JCSSStyleSheetFactory.this;
            }

            public InlineStyle clone() {
                return new MyInlineStyle(this);
            }
        }

        class MyCompatInlineStyle
        extends CompatInlineStyle {
            MyCompatInlineStyle(Node owner) {
                this.setOwnerNode(owner);
            }

            MyCompatInlineStyle(CompatInlineStyle copiedObject) {
                super(copiedObject);
            }

            protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
                return DOM4JCSSStyleSheetFactory.this;
            }

            public InlineStyle clone() {
                return new MyCompatInlineStyle(this);
            }
        }

        class MyDOM4JComputedStyle
        extends DOM4JComputedStyle {
            MyDOM4JComputedStyle(CSSElement ownerNode) {
                super(ownerNode);
            }

            private MyDOM4JComputedStyle(ComputedCSSStyle copiedObject) {
                super(copiedObject);
            }

            protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
                return DOM4JCSSStyleSheetFactory.this;
            }

            public ComputedCSSStyle clone() {
                MyDOM4JComputedStyle styleClone = new MyDOM4JComputedStyle(this);
                return styleClone;
            }
        }
    }
}

