/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSRuleListener;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.InlineStyle;
import io.sf.carte.doc.style.css.om.OMCSSFontFaceRule;
import io.sf.carte.doc.style.css.om.OMCSSImportRule;
import io.sf.carte.doc.style.css.om.OMCSSMediaRule;
import io.sf.carte.doc.style.css.om.OMCSSStyleRule;
import io.sf.carte.doc.style.css.om.OMCSSSupportsRule;
import io.sf.carte.doc.style.css.om.OMMediaList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;

public abstract class BaseDocumentCSSStyleSheet
extends BaseCSSStyleSheet
implements DocumentCSSStyleSheet,
Cloneable {
    private String targetMedium = null;

    protected BaseDocumentCSSStyleSheet(String medium, short origin) {
        super(null, OMMediaList.createUnmodifiable(medium), null, origin);
        this.targetMedium = "all".equals(medium) ? null : medium;
    }

    @Override
    public void setHref(String href) {
        throw new IllegalStateException("Document sheet's href is parent document href");
    }

    @Override
    public String getHref() {
        return this.getOwnerNode() != null ? this.getOwnerNode().getBaseURI() : null;
    }

    @Override
    public abstract CSSDocument getOwnerNode();

    public abstract void setOwnerDocument(CSSDocument var1);

    protected void copyTo(BaseDocumentCSSStyleSheet myCopy) {
        if (myCopy.getTargetMedium() == null) {
            throw new NullPointerException();
        }
        CSSDocument doc = myCopy.getOwnerNode();
        CSSCanvas canvas = doc != null ? doc.getCanvas() : null;
        if (!this.getMedia().matches(myCopy.getTargetMedium(), canvas)) {
            throw new IllegalArgumentException("Incompatible target medium: " + this.targetMedium);
        }
        myCopy.currentInsertionIndex = this.currentInsertionIndex;
        myCopy.setDisabled(this.getDisabled());
        myCopy.namespaces = this.namespaces;
        myCopy.setParentStyleSheet(this.getParentStyleSheet());
        myCopy.cssRules = new CSSRuleArrayList(this.cssRules.getLength());
        int i = 0;
        for (AbstractCSSRule rule : this.cssRules) {
            short type = rule.getType();
            if (type == 4 && !((OMCSSMediaRule)rule).getMedia().matches(this.targetMedium, canvas) || type == 3 && !((OMCSSImportRule)rule).getMedia().matches(this.targetMedium, canvas)) continue;
            myCopy.cssRules.add(rule.clone(myCopy, i++));
        }
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }

    @Override
    public abstract ComputedCSSStyle getComputedStyle(CSSElement var1, String var2);

    @Override
    public abstract BaseDocumentCSSStyleSheet clone();

    @Override
    public abstract BaseDocumentCSSStyleSheet clone(String var1);

    protected ComputedCSSStyle computeStyle(ComputedCSSStyle style, SelectorMatcher matcher, String pseudoElt, InlineStyle inlineStyle) {
        AbstractCSSStyleSheet userImportantStyleSheet;
        SheetErrorHandler eh;
        if (this.getDisabled()) {
            return style;
        }
        matcher.setPseudoElement(pseudoElt);
        Cascade matchingStyles = new Cascade();
        matchingStyles.cascade(matcher, this.getTargetMedium(), this.cssRules);
        Iterator<OMCSSStyleRule> styleit = matchingStyles.iterator();
        if (!styleit.hasNext() && (eh = this.getErrorHandler()) != null) {
            eh.emptyCascade(matcher.toString());
        }
        while (styleit.hasNext()) {
            OMCSSStyleRule rule = styleit.next();
            style.addStyle((BaseCSSStyleDeclaration)rule.getStyle());
        }
        if (!inlineStyle.isEmpty()) {
            style.addStyle(inlineStyle);
        }
        CSSElement elt = (CSSElement)inlineStyle.getOwnerNode();
        if (inlineStyle.hasOverrideStyle(pseudoElt)) {
            style.addStyle((BaseCSSStyleDeclaration)elt.getOwnerDocument().getOverrideStyle(elt, pseudoElt));
        }
        if ((userImportantStyleSheet = this.getStyleSheetFactory().getUserImportantStyleSheet()) != null) {
            Cascade usercascade = new Cascade();
            usercascade.cascade(matcher, this.getTargetMedium(), userImportantStyleSheet.getCssRules());
            styleit = usercascade.iterator();
            while (styleit.hasNext()) {
                OMCSSStyleRule rule = styleit.next();
                style.addStyle((BaseCSSStyleDeclaration)rule.getStyle());
            }
        }
        return style;
    }

    class Cascade {
        private SortedMap<OMCSSStyleRule.RuleSpecifity, LinkedList<OMCSSStyleRule>> matchingStyles = new TreeMap<OMCSSStyleRule.RuleSpecifity, LinkedList<OMCSSStyleRule>>(new OMCSSStyleRule.SpecificityComparator());

        Cascade() {
        }

        void cascade(SelectorMatcher matcher, String targetMedium, CSSRuleArrayList list) {
            for (CSSRule rule : list) {
                short type = rule.getType();
                if (type != 1 && type != 6) {
                    OMCSSSupportsRule supports;
                    CSSCanvas canvas = BaseDocumentCSSStyleSheet.this.getOwnerNode() != null ? BaseDocumentCSSStyleSheet.this.getOwnerNode().getCanvas() : null;
                    if (type == 4) {
                        this.scanMediaRule(matcher, targetMedium, canvas, (OMCSSMediaRule)rule);
                        continue;
                    }
                    if (type == 3) {
                        this.scanImportRule(matcher, targetMedium, canvas, (OMCSSImportRule)rule);
                        continue;
                    }
                    if (type == 5) {
                        this.processFontFaceRule((OMCSSFontFaceRule)rule);
                        continue;
                    }
                    if (type != 12 || canvas == null || !(supports = (OMCSSSupportsRule)rule).supports(canvas)) continue;
                    CSSRuleArrayList rules = supports.getCssRules();
                    for (int i = 0; i < rules.getLength(); ++i) {
                        OMCSSStyleRule stylerule;
                        int selIdx;
                        AbstractCSSRule supportedrule = rules.item(i);
                        if (supportedrule.getType() != 1 || (selIdx = matcher.matches((stylerule = (OMCSSStyleRule)supportedrule).getSelectorList())) == -1) continue;
                        this.add(stylerule.getSpecifity(selIdx));
                    }
                    continue;
                }
                OMCSSStyleRule stylerule = (OMCSSStyleRule)rule;
                int selIdx = matcher.matches(stylerule.getSelectorList());
                if (selIdx == -1) continue;
                this.add(stylerule.getSpecifity(selIdx));
            }
        }

        private void scanMediaRule(SelectorMatcher matcher, String targetMedium, CSSCanvas canvas, OMCSSMediaRule mediaRule) {
            MediaQueryList mediaList = mediaRule.getMedia();
            if (targetMedium != null && mediaList.matches(targetMedium, canvas)) {
                CSSRuleList ruleList = mediaRule.getCssRules();
                int rll = ruleList.getLength();
                for (int i = 0; i < rll; ++i) {
                    OMCSSStyleRule stylerule;
                    int selIdx;
                    if (!(ruleList.item(i) instanceof OMCSSStyleRule) || (selIdx = matcher.matches((stylerule = (OMCSSStyleRule)ruleList.item(i)).getSelectorList())) < 0) continue;
                    this.add(stylerule.getSpecifity(selIdx));
                }
            }
        }

        private void scanImportRule(SelectorMatcher matcher, String targetMedium, CSSCanvas canvas, OMCSSImportRule importRule) {
            AbstractCSSStyleSheet sheet;
            MediaQueryList mediaList = importRule.getMedia();
            if ((mediaList.isAllMedia() || targetMedium != null && mediaList.matches(targetMedium, canvas)) && (sheet = importRule.getStyleSheet()) != null) {
                CSSRuleArrayList ruleList = sheet.getCssRules();
                int rll = ruleList.getLength();
                for (int i = 0; i < rll; ++i) {
                    OMCSSStyleRule stylerule;
                    int selIdx;
                    if (!(ruleList.item(i) instanceof OMCSSStyleRule) || (selIdx = matcher.matches((stylerule = (OMCSSStyleRule)ruleList.item(i)).getSelectorList())) < 0) continue;
                    this.add(stylerule.getSpecifity(selIdx));
                }
            }
        }

        private void processFontFaceRule(OMCSSFontFaceRule rule) {
            Document doc = rule.getParentStyleSheet().getOwnerNode().getOwnerDocument();
            if (doc instanceof CSSRuleListener) {
                ((CSSRuleListener)((Object)doc)).onFontFaceRule(rule);
            }
        }

        void add(OMCSSStyleRule.RuleSpecifity sp) {
            if (this.matchingStyles.containsKey(sp)) {
                ((LinkedList)this.matchingStyles.get(sp)).add(sp.getCSSStyleRule());
            } else {
                LinkedList<OMCSSStyleRule> matchingRules = new LinkedList<OMCSSStyleRule>();
                matchingRules.add(sp.getCSSStyleRule());
                this.matchingStyles.put(sp, matchingRules);
            }
        }

        Iterator<OMCSSStyleRule> iterator() {
            return new RuleIterator();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            Iterator<OMCSSStyleRule> it = this.iterator();
            while (it.hasNext()) {
                OMCSSStyleRule rule = it.next();
                buf.append(rule.getOrigin()).append(": ").append(rule.getCssText()).append('\n');
            }
            return buf.toString();
        }

        class RuleIterator
        implements Iterator<OMCSSStyleRule> {
            private Iterator<OMCSSStyleRule.RuleSpecifity> keyit;
            private Iterator<OMCSSStyleRule> currentList;

            RuleIterator() {
                this.keyit = Cascade.this.matchingStyles.keySet().iterator();
                if (this.keyit.hasNext()) {
                    this.findCurrentList();
                } else {
                    this.currentList = null;
                }
            }

            private void findCurrentList() {
                while (this.currentList == null || !this.currentList.hasNext()) {
                    if (this.keyit.hasNext()) {
                        this.currentList = ((LinkedList)Cascade.this.matchingStyles.get(this.keyit.next())).iterator();
                        continue;
                    }
                    this.currentList = null;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.currentList != null;
            }

            @Override
            public OMCSSStyleRule next() {
                if (this.currentList != null && this.currentList.hasNext()) {
                    OMCSSStyleRule thenext = this.currentList.next();
                    this.findCurrentList();
                    return thenext;
                }
                throw new NoSuchElementException();
            }
        }
    }
}

