/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.PositionalCondition2;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.DefaultStyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.PropertyDocumentHandler;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CharacterDataSelector;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.ProcessingInstructionSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.DOMException;

public abstract class CSSStyleDeclarationRule
extends BaseCSSRule {
    private AbstractCSSStyleDeclaration declaration = null;
    private SelectorList selectorList = null;
    private String selectorText = null;
    StyleDeclarationErrorHandler sdErrorHandler = null;

    protected CSSStyleDeclarationRule(AbstractCSSStyleSheet parentSheet, short type, short origin) {
        super(parentSheet, type, origin);
        this.declaration = parentSheet.createCSSStyleDeclaration(this);
    }

    protected CSSStyleDeclarationRule() {
        super(null, (short)1, (short)0);
        this.declaration = new BaseCSSStyleDeclaration(this);
        this.sdErrorHandler = new DefaultStyleDeclarationErrorHandler();
    }

    public AbstractCSSStyleDeclaration getStyle() {
        return this.declaration;
    }

    public String getSelectorText() {
        return this.selectorText;
    }

    public void setSelectorText(String selectorText) throws DOMException {
        this.selectorText = selectorText;
    }

    void setSelectorList(SelectorList selectorList) {
        this.selectorList = selectorList;
        int sz = selectorList.getLength();
        StringBuilder sb = new StringBuilder(sz * 7 + 5);
        if (sz > 0) {
            CSSStyleDeclarationRule.selectorListText(sb, selectorList, false);
        }
        this.setSelectorText(sb.toString());
    }

    SelectorList getSelectorList() {
        return this.selectorList;
    }

    @Override
    public String getMinifiedCssText() {
        return this.getSelectorText() + '{' + this.getStyle().getMinifiedCssText() + '}';
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.declaration.clear();
        this.selectorList = null;
        this.selectorText = null;
        Parser parser = this.createSACParser();
        InputSource source = new InputSource();
        StringReader re = new StringReader(cssText);
        source.setCharacterStream((Reader)re);
        RuleDocumentHandler handler = new RuleDocumentHandler();
        handler.setLexicalRuleListener(this.declaration);
        parser.setDocumentHandler((DocumentHandler)handler);
        try {
            parser.parseRule(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(12, e.getMessage());
        }
        if (this.selectorList == null) {
            throw new DOMException(12, "No selectors found");
        }
    }

    @Override
    public String getCssText() {
        return this.getSelectorText() + ' ' + '{' + this.getStyle().getCssText() + '}';
    }

    public String toString() {
        return this.getCssText();
    }

    public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        if (this.sdErrorHandler == null) {
            this.sdErrorHandler = this.getParentStyleSheet().getStyleSheetFactory().createStyleDeclarationErrorHandler(this);
        }
        return this.sdErrorHandler;
    }

    public void setStyleDeclarationErrorHandler(StyleDeclarationErrorHandler handler) {
        this.sdErrorHandler = handler;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaration == null ? 0 : this.declaration.hashCode());
        result = 31 * result + (this.selectorList == null ? 0 : this.selectorList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CSSStyleDeclarationRule other = (CSSStyleDeclarationRule)obj;
        if (this.declaration == null ? other.declaration != null : !this.declaration.equals(other.declaration)) {
            return false;
        }
        return !(this.selectorList == null ? other.selectorList != null : !this.selectorList.equals(other.selectorList));
    }

    @Override
    public CSSStyleDeclarationRule clone(AbstractCSSStyleSheet parentSheet, int insertionIndex) throws IllegalArgumentException {
        CSSStyleDeclarationRule rule;
        Constructor<?> ctor;
        Class[] parameterTypes = new Class[]{AbstractCSSStyleSheet.class, Short.TYPE};
        try {
            ctor = this.getClass().getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        Object[] initargs = new Object[]{parentSheet, this.getOrigin()};
        try {
            rule = (CSSStyleDeclarationRule)ctor.newInstance(initargs);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle());
        rule.selectorList = this.getSelectorList();
        rule.selectorText = this.getSelectorText();
        rule.setInsertionIndex(insertionIndex);
        return rule;
    }

    private void setWrappedStyle(BaseCSSStyleDeclaration style) {
        this.declaration = new StyleWrapper(style);
    }

    static String selectorText(Selector sel, boolean omitUniversal) {
        switch (sel.getSelectorType()) {
            case 1: {
                if (sel instanceof SiblingSelector) {
                    SiblingSelector asel = (SiblingSelector)sel;
                    return CSSStyleDeclarationRule.selectorText(asel.getSelector(), omitUniversal) + "~" + CSSStyleDeclarationRule.selectorText((Selector)asel.getSiblingSelector(), false);
                }
                return omitUniversal ? "" : "*";
            }
            case 4: {
                ElementSelector esel = (ElementSelector)sel;
                if (esel.getNamespaceURI() != null) {
                    return esel.getNamespaceURI() + "|" + esel.getLocalName();
                }
                String name = esel.getLocalName();
                return name != null ? name : (omitUniversal ? "" : "*");
            }
            case 11: {
                DescendantSelector dsel = (DescendantSelector)sel;
                String anctext = CSSStyleDeclarationRule.selectorText(dsel.getAncestorSelector(), false);
                String desctext = CSSStyleDeclarationRule.selectorText((Selector)dsel.getSimpleSelector(), false);
                StringBuilder buf = new StringBuilder(anctext.length() + desctext.length() + 3);
                buf.append(anctext);
                short stype = dsel.getSimpleSelector().getSelectorType();
                if (stype != 9 && stype != 3) {
                    buf.append(" > ");
                }
                buf.append(desctext);
                return buf.toString();
            }
            case 0: {
                ConditionalSelector csel = (ConditionalSelector)sel;
                return CSSStyleDeclarationRule.conditionalSelectorText(csel.getCondition(), csel.getSimpleSelector());
            }
            case 10: {
                DescendantSelector dsel = (DescendantSelector)sel;
                String anctext = CSSStyleDeclarationRule.selectorText(dsel.getAncestorSelector(), false);
                String desctext = CSSStyleDeclarationRule.selectorText((Selector)dsel.getSimpleSelector(), false);
                StringBuilder buf = new StringBuilder(anctext.length() + desctext.length() + 1);
                buf.append(anctext);
                if (dsel.getSimpleSelector().getSelectorType() != 9) {
                    buf.append(' ');
                }
                buf.append(desctext);
                return buf.toString();
            }
            case 12: {
                SiblingSelector asel = (SiblingSelector)sel;
                return CSSStyleDeclarationRule.selectorText(asel.getSelector(), omitUniversal) + " + " + CSSStyleDeclarationRule.selectorText((Selector)asel.getSiblingSelector(), false);
            }
            case 13: {
                SiblingSelector asel = (SiblingSelector)sel;
                return CSSStyleDeclarationRule.selectorText(asel.getSelector(), omitUniversal) + "~" + CSSStyleDeclarationRule.selectorText((Selector)asel.getSiblingSelector(), false);
            }
            case 14: {
                DescendantSelector dsel = (DescendantSelector)sel;
                return CSSStyleDeclarationRule.selectorText(dsel.getAncestorSelector(), omitUniversal) + "||" + CSSStyleDeclarationRule.selectorText((Selector)dsel.getSimpleSelector(), false);
            }
            case 3: {
                return ":not(" + CSSStyleDeclarationRule.selectorText((Selector)((NegativeSelector)sel).getSimpleSelector(), false) + ")";
            }
            case 9: {
                ElementSelector esel = (ElementSelector)sel;
                String name = esel.getLocalName().intern();
                name = name == "first-line" || name == "first-letter" || name == "before" || name == "after" ? ':' + name : "::" + name;
                if (esel.getNamespaceURI() != null) {
                    return esel.getNamespaceURI() + '|' + name;
                }
                return name;
            }
            case 2: {
                return ":root";
            }
            case 7: {
                ProcessingInstructionSelector pisel = (ProcessingInstructionSelector)sel;
                return "<?" + pisel.getTarget() + " " + pisel.getData() + "?>";
            }
            case 6: {
                return ((CharacterDataSelector)sel).getData();
            }
            case 8: {
                return ((CharacterDataSelector)sel).getData();
            }
            case 5: {
                return ((CharacterDataSelector)sel).getData();
            }
        }
        return null;
    }

    private static String conditionalSelectorText(Condition condition, SimpleSelector simpleSelector) {
        switch (condition.getConditionType()) {
            case 9: {
                AttributeCondition acond = (AttributeCondition)condition;
                StringBuilder buf = new StringBuilder(16);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                buf.append(".").append(acond.getValue());
                return buf.toString();
            }
            case 5: {
                return "#" + ((AttributeCondition)condition).getValue();
            }
            case 4: {
                String value;
                AttributeCondition acond = (AttributeCondition)condition;
                StringBuilder buf = new StringBuilder(32);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                if ((value = acond.getValue()) != null) {
                    buf.append('[').append(acond.getLocalName()).append("=\"").append(value).append("\"]");
                } else {
                    buf.append('[').append(acond.getLocalName()).append(']');
                }
                return buf.toString();
            }
            case 14: {
                AttributeCondition acond = (AttributeCondition)condition;
                StringBuilder buf = new StringBuilder(48);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                String value = acond.getValue();
                buf.append('[').append(acond.getLocalName()).append("^=\"").append(value).append("\"]");
                return buf.toString();
            }
            case 8: {
                AttributeCondition acond = (AttributeCondition)condition;
                StringBuilder buf = new StringBuilder(48);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                buf.append('[').append(acond.getLocalName()).append("|=\"").append(acond.getValue()).append("\"]");
                return buf.toString();
            }
            case 15: {
                AttributeCondition acond = (AttributeCondition)condition;
                StringBuilder buf = new StringBuilder(48);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                String value = acond.getValue();
                buf.append('[').append(acond.getLocalName()).append("$=\"").append(value).append("\"]");
                return buf.toString();
            }
            case 16: {
                AttributeCondition acond = (AttributeCondition)condition;
                StringBuilder buf = new StringBuilder(48);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                String value = acond.getValue();
                buf.append('[').append(acond.getLocalName()).append("*=\"").append(value).append("\"]");
                return buf.toString();
            }
            case 6: {
                StringBuilder buf = new StringBuilder(32);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                buf.append(":lang(").append(((LangCondition)condition).getLang()).append(')');
                return buf.toString();
            }
            case 2: {
                return ":not(" + CSSStyleDeclarationRule.conditionalSelectorText(((NegativeCondition)condition).getCondition(), simpleSelector) + ")";
            }
            case 7: {
                AttributeCondition acond = (AttributeCondition)condition;
                StringBuilder buf = new StringBuilder(48);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                buf.append('[').append(acond.getLocalName()).append("~=\"").append(acond.getValue()).append("\"]");
                return buf.toString();
            }
            case 11: {
                StringBuilder buf = new StringBuilder(16);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                return buf.append(":only-child").toString();
            }
            case 12: {
                StringBuilder buf = new StringBuilder(16);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                return buf.append(":only-of-type").toString();
            }
            case 3: {
                StringBuilder buf = new StringBuilder(50);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                PositionalCondition2 pcond = (PositionalCondition2)condition;
                buf.append(':');
                int slope = pcond.getFactor();
                if (pcond.getType()) {
                    if (slope == 0) {
                        if (pcond.getPosition() == 1) {
                            buf.append("first-of-type");
                        } else if (pcond.getPosition() == -1) {
                            buf.append("last-of-type");
                        } else {
                            if (pcond.isForwardCondition()) {
                                buf.append("nth-of-type(");
                            } else {
                                buf.append("nth-last-of-type(");
                            }
                            buf.append(pcond.getOffset()).append(')');
                        }
                    } else {
                        if (pcond.isForwardCondition()) {
                            buf.append("nth-of-type(");
                        } else {
                            buf.append("nth-last-of-type(");
                        }
                        buf.append(slope).append('n');
                        int offset = pcond.getOffset();
                        if (offset > 0) {
                            buf.append('+');
                        }
                        buf.append(offset).append(')');
                    }
                } else {
                    int offset = pcond.getOffset();
                    SelectorList selist = pcond.getOfList();
                    if (slope == 0) {
                        if (offset == 1 && CSSStyleDeclarationRule.isUniversalSelectorList(selist)) {
                            if (pcond.isForwardCondition()) {
                                buf.append("first-child");
                            } else {
                                buf.append("last-child");
                            }
                        } else {
                            if (pcond.isForwardCondition()) {
                                buf.append("nth-child(");
                            } else {
                                buf.append("nth-last-child(");
                            }
                            buf.append(offset);
                            if (!CSSStyleDeclarationRule.isUniversalSelectorList(selist)) {
                                buf.append(" of ");
                                CSSStyleDeclarationRule.selectorListText(buf, pcond.getOfList(), true);
                            }
                            buf.append(')');
                        }
                    } else {
                        if (pcond.isForwardCondition()) {
                            buf.append("nth-child(");
                        } else {
                            buf.append("nth-last-child(");
                        }
                        buf.append(slope).append('n');
                        if (offset > 0) {
                            buf.append('+');
                        }
                        buf.append(offset);
                        if (!CSSStyleDeclarationRule.isUniversalSelectorList(selist)) {
                            buf.append(" of ");
                            CSSStyleDeclarationRule.selectorListText(buf, selist, true);
                        }
                        buf.append(')');
                    }
                }
                return buf.toString();
            }
            case 10: {
                AttributeCondition acond = (AttributeCondition)condition;
                StringBuilder buf = new StringBuilder(16);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                String name = acond.getLocalName();
                String value = acond.getValue();
                if (name == null) {
                    name = value;
                } else if (value != null) {
                    name = name + "(" + value + ")";
                }
                return buf.append(':').append(name).toString();
            }
            case 18: {
                AttributeCondition acond = (AttributeCondition)condition;
                StringBuilder buf = new StringBuilder(16);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                return buf.append(':').append(':').append(acond.getLocalName()).toString();
            }
            case 1: {
                CombinatorCondition ccond = (CombinatorCondition)condition;
                return ":matches(" + CSSStyleDeclarationRule.conditionalSelectorText(ccond.getFirstCondition(), null) + "," + CSSStyleDeclarationRule.conditionalSelectorText(ccond.getSecondCondition(), null) + ")";
            }
            case 0: {
                CombinatorCondition ccond = (CombinatorCondition)condition;
                return CSSStyleDeclarationRule.conditionalSelectorText(ccond.getFirstCondition(), simpleSelector) + CSSStyleDeclarationRule.conditionalSelectorText(ccond.getSecondCondition(), null);
            }
            case 17: {
                ArgumentCondition args = (ArgumentCondition)condition;
                StringBuilder buf = new StringBuilder(48);
                buf.append(':').append(args.getName()).append("(");
                CSSStyleDeclarationRule.selectorListText(buf, args.getSelectors(), true);
                return buf.append(')').toString();
            }
        }
        return null;
    }

    private static void selectorListText(StringBuilder buf, SelectorList selist, boolean omitUniversal) {
        buf.append(CSSStyleDeclarationRule.selectorText(selist.item(0), omitUniversal));
        for (int i = 1; i < selist.getLength(); ++i) {
            buf.append(',').append(CSSStyleDeclarationRule.selectorText(selist.item(i), omitUniversal));
        }
    }

    private static boolean isUniversalSelectorList(SelectorList selist) {
        if (selist == null) {
            return true;
        }
        for (int i = 0; i < selist.getLength(); ++i) {
            if (selist.item(i).getSelectorType() != 1) continue;
            return true;
        }
        return false;
    }

    public class RuleDocumentHandler
    extends PropertyDocumentHandler {
        @Override
        public void startSelector(SelectorList selectors) throws CSSException {
            CSSStyleDeclarationRule.this.setSelectorList(selectors);
        }

        @Override
        public void endSelector(SelectorList selectors) throws CSSException {
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            block2: {
                try {
                    super.property(name, value, important);
                }
                catch (DOMException e) {
                    if (CSSStyleDeclarationRule.this.getStyleDeclarationErrorHandler() == null) break block2;
                    CSSPropertyValueException ex = new CSSPropertyValueException(e);
                    ex.setValueText(value.toString());
                    CSSStyleDeclarationRule.this.getStyleDeclarationErrorHandler().wrongValue(name, ex);
                }
            }
        }
    }

    private class StyleWrapper
    extends BaseCSSStyleDeclaration {
        private StyleWrapper(BaseCSSStyleDeclaration copiedObject) {
            super(copiedObject);
        }

        @Override
        public CSSStyleDeclarationRule getParentRule() {
            return CSSStyleDeclarationRule.this;
        }
    }
}

