/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.om.OMCSSGroupingRule;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSMediaRule;

public class OMCSSMediaRule
extends OMCSSGroupingRule
implements CSSMediaRule {
    private MediaQueryList mediaList = null;

    public OMCSSMediaRule(AbstractCSSStyleSheet parentSheet, MediaQueryList mediaList, short origin) {
        super(parentSheet, (short)4, origin);
        this.mediaList = mediaList;
    }

    public OMCSSMediaRule(AbstractCSSStyleSheet parentSheet, OMCSSMediaRule copyfrom) {
        super(parentSheet, copyfrom);
        this.mediaList = ((MediaListAccess)((Object)copyfrom.getMedia())).unmodifiable();
    }

    @Override
    public MediaQueryList getMedia() {
        return this.mediaList;
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder(30 + ((CSSRuleArrayList)this.getCssRules()).getLength() * 20);
        sb.append("@media ").append(this.mediaList.getMediaText()).append(" {\n");
        Iterator it = ((ArrayList)((Object)this.getCssRules())).iterator();
        while (it.hasNext()) {
            sb.append(((AbstractCSSRule)it.next()).getCssText()).append('\n');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder sb = new StringBuilder(30 + ((CSSRuleArrayList)this.getCssRules()).getLength() * 20);
        sb.append("@media ").append(this.mediaList.getMediaText()).append("{");
        Iterator it = ((ArrayList)((Object)this.getCssRules())).iterator();
        while (it.hasNext()) {
            sb.append(((AbstractCSSRule)it.next()).getMinifiedCssText());
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public OMCSSMediaRule clone(AbstractCSSStyleSheet parentSheet, int insertionIndex) {
        return new OMCSSMediaRule(parentSheet, this);
    }
}

